#ifndef _interface_h__
#define _interface_h__

#include <avr/io.h>

// highest dac number
#define MAX_DAC 16

// DAC A0
#define PDA0 PORTB
#define DDA0 DDRB
#define BDA0 1

// DAC A1
#define PDA1 PORTB
#define DDA1 DDRB
#define BDA1 2

// DAC A2
#define PDA2 PORTB
#define DDA2 DDRB
#define BDA2 3

// DAC A3
#define PDA3 PORTB
#define DDA3 DDRB
#define BDA3 0


#define _SETDACBIT(bit, value) {if(value & _BV(bit)) PDA ## bit  |= _BV(BDA ## bit); else PDA ## bit  &= ~_BV(BDA ## bit);}

int sensors_init(void);
int sensors_getNumChannels(void);
int sensors_getChipID(unsigned char id);

/** 
 * \brief Called to get a raw value from a sensor. 
 * \return Number of bytes returned (max 6)
 **/
int sensors_getRaw(unsigned char id, unsigned char *dst);


#endif // _interface_h__

