/* Autogenerated with DRAKON Editor 1.23 */
#include "indexed.h"

#include <memory.h>
#include <stdio.h>
static int str_eq(
    const char* expected,
    const string8* actual
);







struct indexed {
    tobject base;
    array_table employee;
    hashtable* employee_by_name;
    int error_code;
};
static type_info_t indexed_t = {
	OBJECT_SIGNATURE,
	"indexed",
	(destructor_fun)indexed_destroy
};
struct employee {
    row_base _row;
    string8* name;
};


static int
delete_generic(indexed* db,
    obj_list* deletion_list);


static int
ensure_can_delete(indexed* db,
    void* record,
    obj_list* deletion_list);


static void
do_delete(indexed* db,
    void* record,
    obj_list* deletion_list,
    int unlink);


static int
record_destructor(void* record,
    void* dbv);


static int
employee_pre_delete(indexed* db,
    employee* record,
    obj_list* deletion_list,
    int master);


static int
employee_ensure_can_delete(indexed* db,
    employee* record,
    obj_list* deletion_list);


static void
employee_do_delete(indexed* db,
    employee* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
employee_by_name_hash(const void* vobj);


static int
employee_by_name_eq(const void* lobj,
    const void* robj);


indexed* /* own */
indexed_create(void) {
    indexed* me = allocate_memory(sizeof(indexed));
    me->base.type = &indexed_t;
    array_table_init(&me->employee, "employee");
    me->employee.do_delete = (dd_fun)employee_do_delete;
    me->employee.ensure_can_delete = (ensure_cd_fun)employee_ensure_can_delete;
    me->employee_by_name = hashtable_create(0, employee_by_name_hash, employee_by_name_eq);
    return me;
}


void
indexed_destroy(indexed* me /* own. null */) {
    if (!me) return;
    ENSURE(me->base.type == &indexed_t)
    hashtable_destroy(me->employee_by_name);
    indexed_foreach_employee(
        me,
        (employee_fun)record_destructor,
        me);
    array_table_cleanup(&me->employee);
    free_memory(me, sizeof(indexed));
}


int
indexed_error(const indexed* db) {
    return db->error_code;
}


int
employee_id(const employee* me) {
    return me->_row.id;
}


employee* /* null */
indexed_get_employee(indexed* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->employee.next) return 0;
    return db->employee.items[rec_id];
}


const string8* /* null */
employee_cget_name(const employee* me) {
    return me->name;
}


int
indexed_set_employee_name(indexed* db,
    employee* _record_,
    string8* new_value /* own. null */) {
    employee* found;
    employee _key_;
    ENSURE(_record_ == indexed_get_employee(db, _record_->_row.id))
    if (_record_->name == new_value) {
        return 1;
    }
    _key_.name = new_value;
    found = hashtable_get(db->employee_by_name, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    hashtable_remove(db->employee_by_name, _record_);
    if (_record_->name) {
        string8_destroy(_record_->name);
    }
    _record_->name = new_value;
    hashtable_put(db->employee_by_name, _record_);
    return 1;
}


employee* /* null */
indexed_insert_employee(indexed* db,
    string8* name /* own. null */) {
    employee* _record_;
    int rec_id;
    employee _key_;
    employee* found;
    _record_ = 0;
    _key_.name = name;
    found = hashtable_get(db->employee_by_name, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    _record_ = allocate_memory(sizeof(employee));
    rec_id = array_table_insert(&db->employee, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->employee;
    _record_->name = name;
    hashtable_put(db->employee_by_name, _record_);
    return _record_;
}


int
indexed_delete_employee(indexed* db,
    employee* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == indexed_get_employee(db, record->_row.id))
    if (employee_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
indexed_employee_count(const indexed* db) {
    return db->employee.count;
}


int
indexed_foreach_employee(indexed* db,
    employee_fun visitor,
    void* user_data /* null */) {
    int i, n;
    employee* current;
    n = db->employee.next;
    for (i = 0; i < n; i++) {
        current = db->employee.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


employee* /* null */
indexed_employee_by_name(indexed* db,
    const string8* name /* null */) {
    employee _key_;
    _key_.name = (string8*)name;
    return hashtable_get(db->employee_by_name, &_key_);
}


static int
delete_generic(indexed* db,
    obj_list* deletion_list) {
    void* record;
    int i, n;
    n = obj_list_length(deletion_list);
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        if (!ensure_can_delete(db, record, deletion_list)) {
            return 0;
        }
    }
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        do_delete(db, record, deletion_list, 1);
    }
    return 1;
}


static int
ensure_can_delete(indexed* db,
    void* record,
    obj_list* deletion_list) {
    row_base* row = record;
    return row->table->ensure_can_delete(
        db,
        record,
        deletion_list);
}


static void
do_delete(indexed* db,
    void* record,
    obj_list* deletion_list,
    int unlink) {
    row_base* row = record;
    row->table->do_delete(
        db,
        record,
        deletion_list,
        unlink);
}


static int
record_destructor(void* record,
    void* dbv) {
    indexed* db = dbv;
    do_delete(
        db,
        record,
        0,
        0);
    return 0;
}


static int
employee_pre_delete(indexed* db,
    employee* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    return 1;
}


static int
employee_ensure_can_delete(indexed* db,
    employee* record,
    obj_list* deletion_list) {
    return 1;
}


static void
employee_do_delete(indexed* db,
    employee* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        hashtable_remove(db->employee_by_name, record);
        array_table_delete(&db->employee, record->_row.id);
    }
    string8_destroy(record->name);
    free_memory(record, sizeof(employee));
}


static unsigned int
employee_by_name_hash(const void* vobj) {
    const employee* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = string8_hash(obj->name);
    return code;
}


static int
employee_by_name_eq(const void* lobj,
    const void* robj) {
    const employee* left;
    const employee* right;
    left = lobj;
    right = robj;
    if (!string8_equal(left->name, right->name)) return 0;
    return 1;
}
static int str_eq(
    const char* expected,
    const string8* actual
) {
    // item 190
    int result;
    /* item 187 */
    string8* exp = string8_from_cstr(expected, 50); // own
    /* item 191 */
    result = string8_equal(actual, exp);
    /* item 188 */
    string8_destroy(exp);
    /* item 189 */
    return result;
    
}

int main(
    int argc,
    char** argv
) {
    // item 203
    employee* john;
    employee* mark;
    /* item 176 */
    indexed* db = indexed_create();
    string8* connor_str = string8_from_cstr("John Connor", 100);
    string8* john_str = string8_from_cstr("John", 10);
    string8* mark_str = string8_from_cstr("Mark", 10);
    /* item 35 */
    ENSURE(0 ==  indexed_employee_by_name(db, john_str))
    ENSURE(0 ==  indexed_employee_by_name(db, mark_str))
    ENSURE(0 ==  indexed_employee_by_name(db, connor_str))
    /* item 76 */
    john = indexed_insert_employee(
    	db,
    	string8_from_cstr("John", 10));
    
    mark = indexed_insert_employee(
    	db,
    	string8_from_cstr("Mark", 10));
    /* item 206 */
    ENSURE(john)
    ENSURE(mark)
    /* item 177 */
    ENSURE(john ==  indexed_employee_by_name(db, john_str))
    ENSURE(mark == indexed_employee_by_name(db, mark_str))
    
    ENSURE(0 == indexed_employee_by_name(db, 0))
    /* item 114 */
    ENSURE(0 == indexed_insert_employee(
    	db,
    	john_str))
    /* item 118 */
    ENSURE(indexed_set_employee_name(
     db, 
     john, 
     string8_from_cstr("John", 10)))
    /* item 120 */
    ENSURE(str_eq("John", employee_cget_name(john)))
    ENSURE(john ==  indexed_employee_by_name(db, john_str))
    /* item 178 */
    ENSURE(indexed_set_employee_name(db, john, mark_str) == 0)
    /* item 204 */
    ENSURE(indexed_set_employee_name(db, john, 
     string8_from_cstr("John Connor", 100)))
    /* item 180 */
    ENSURE(0 ==  indexed_employee_by_name(db, john_str))
    ENSURE(john ==  indexed_employee_by_name(db, connor_str))
    /* item 127 */
    ENSURE(str_eq("John Connor", employee_cget_name(john)))
    ENSURE(str_eq("Mark", employee_cget_name(mark)))
    /* item 99 */
    indexed_delete_employee(db, john);
    indexed_delete_employee(db, mark);
    /* item 205 */
    ENSURE(0 ==  indexed_employee_by_name(db, john_str))
    ENSURE(0 ==  indexed_employee_by_name(db, connor_str))
    ENSURE(0 ==  indexed_employee_by_name(db, mark_str))
    /* item 202 */
    object_destroy(db);
    object_destroy(john_str);
    object_destroy(mark_str);
    object_destroy(connor_str);
    /* item 207 */
    return 0;
    
}



