namespace eval tab {



# Autogenerated with DRAKON Editor 1.27

proc actions_and_shelves { } {
    #item 209
    set vertex_ids [ vertex_type_keys ]
    #item 210
    set result {}
    foreach vertex_id $vertex_ids {
        #item 214
        set type [ get_vertex_type $vertex_id ]
        #item 2150001
        if {($type == "action") || ($type == "shelf")} {
            #item 223
            lappend result $vertex_id
        } else {
            
        }
    }
    #item 211
    return $result
}

proc add_class { name properties defined } {
    #item 127
    set id [ class_next_id ]
    #item 145
    set key [ string tolower $name ]
    #item 131
    insert_class $id $name $properties {} {} {} $defined
    #item 129
    insert_class_by_name $key $id
    #item 970
    return $id
}

proc add_class_declaration { vertex_id } {
    #item 879
    set name [ get_vertex_text $vertex_id ]
    #item 899
    set parts [ split_space $name ]
    #item 904
    if {[ lindex $parts 0 ] == ""} {
        #item 907
        report_error_vertex $vertex_id \
         "Class name expected here"
    } else {
        
    }
    #item 900
    if {[ lindex $parts 0 ] == "class"} {
        #item 903
        report_error_vertex $vertex_id \
         "'class' keyword not expected here"
    } else {
        
    }
    #item 894
    set id [ find_class $name ]
    #item 895
    if {$id == ""} {
        #item 898
        add_class $name {} 0
    } else {
        
    }
}

proc add_class_definition { vertex_id } {
    #item 909
    set header [ get_vertex_text2 $vertex_id ]
    #item 940
    set header_parts [ split $header ":" ]
    lassign $header_parts header_start header_end
    #item 935
    set parts [ split_space $header_start ]
    set options [ split_space $header_end ]
    #item 920
    if {[ llength $parts ] == 2} {
        #item 937
        lassign $parts class name
        #item 911
        if {($class == "class") && (!($name == ""))} {
            
        } else {
            #item 914
            report_error_vertex $vertex_id \
             "'class <Class Name>' expected here"
        }
    } else {
        #item 914
        report_error_vertex $vertex_id \
         "'class <Class Name>' expected here"
    }
    #item 938
    set body [ get_vertex_text $vertex_id ]
    set body_lines [ split_lines $body ]
    #item 961
    set id [ find_class $name ]
    #item 962
    if {$id == ""} {
        #item 965
        set id [ add_class $name $options 1 ]
    } else {
        #item 966
        if {[get_class_defined $id]} {
            #item 969
            report_error_vertex $vertex_id \
             "class $name is already defined elsewhere"
        } else {
            #item 971
            set_class_defined $id 1
            set_class_properties $id $options
        }
    }
    #item 991
    set indices {}
    foreach line $body_lines {
        #item 974
        set line_parts [ split $line ":" ]
        lassign $line_parts line_begin line_end
        #item 975
        set begin_parts [ split_space $line_begin ]
        set tail_parts [ split_space $line_end ]
        #item 979
        set begin_length [ llength $begin_parts ]
        #item 9800001
        if {$begin_length == 0} {
            #item 988
            report_error_vertex $vertex_id \
             "error in field definition: $line"
        } else {
            #item 9800002
            if {$begin_length == 1} {
                #item 989
                create_field $id $begin_parts $tail_parts \
                  $vertex_id
            } else {
                #item 990
                lappend indices \
                 [ list $begin_parts $tail_parts ]
            }
        }
    }
    foreach index $indices {
        #item 997
        create_index $id $index $vertex_id
    }
}

proc add_diagram { dbase diagram_id } {
    #item 191
    set name [ $dbase onecolumn {
    	select name
    	from diagrams
    	where diagram_id = :diagram_id } ]
    #item 194
    set vertices {}
    #item 192
    $dbase eval {
    	select vertex_id, item_id, type, text, text2, left, up, right, down
    	from vertices
    	where diagram_id = :diagram_id
    	order by vertex_id
    } {
    	insert_vertex $vertex_id $item_id $diagram_id $type $text $text2 $left $up $right $down
    	lappend vertices $vertex_id
    }
    #item 193
    $dbase eval {
    	select edge_id, vertex1, vertex2, head, vertical, items
    	from edges
    	where diagram_id = :diagram_id
    	order by edge_id
    } {
    	insert_edge $edge_id $vertex1 $vertex2 $head $vertical $items 0
    }
    #item 195
    insert_diagram $diagram_id $name $vertices
}

proc add_field { name properties class_id } {
    #item 107
    set key [ make_field_key $class_id $name ]
    #item 108
    set id [ field_next_id ]
    #item 109
    insert_field $id $class_id $name $properties
    #item 113
    insert_field_by_name $key $id
    #item 110
    set class_fields [ get_class_fields $class_id ]
    #item 111
    lappend class_fields $id
    #item 112
    set_class_fields $class_id $class_fields
}

proc add_index { class_id name properties fields } {
    #item 155
    set id [ index_next_id ]
    #item 156
    insert_index $id $class_id $name $properties $fields
    #item 157
    set indexes [ get_class_indexes $class_id ]
    #item 158
    lappend indexes $id
    #item 159
    set_class_indexes $class_id $indexes
}

proc add_link { type ownership src_vertex dst_vertex src_field_id dst_field_id edge } {
    #item 180
    set id [ link_next_id ]
    #item 1289
    set src_class [ get_vertex_class $src_vertex ]
    set dst_class [ get_vertex_class $dst_vertex ]
    #item 845
    set src [ find_class $src_class ]
    set dst [ find_class $dst_class ]
    #item 1288
    set src_field [ get_vertex_text $src_field_id ]
    set dst_field [ get_vertex_text $dst_field_id ]
    #item 1160
    ensure_no_fields_reuse $src $src_field $edge
    ensure_no_fields_reuse $dst $dst_field $edge
    #item 181
    add_link_to_class $src $id
    add_link_to_class $dst $id
    #item 182
    insert_link $id $type $ownership $src $dst $src_field $dst_field
}

proc add_link_to_class { class_id link_id } {
    #item 177
    set class_links [ get_class_links $class_id ]
    #item 178
    lappend class_links $link_id
    #item 179
    set_class_links $class_id $class_links
}

proc assemble_trees { nodes edges } {
    #item 2892
    set node_ids [ dict keys $nodes ]
    
    set normal_2893 1
    foreach node_id $node_ids {
        #item 2895
        set node [ dict get $nodes $node_id ]
        set text [ get_tnode_text $node ]
        #item 2905
        if {[string trim $text] == ""} {
            #item 2908
            error "Some icons do not contains significat text"
            set normal_2893 0
            break
        } else {
            
        }
    }
    if {$normal_2893 == 1} {
        #item 2923
        set roots {}
        foreach node_id $node_ids {
            #item 2955
            set incoming \
            [get_tnode_incoming $node_id $edges]
            #item 2956
            if {$incoming == {}} {
                #item 2983
                lappend roots $node_id
            } else {
                
            }
        }
    }
    #item 2984
    set trees {}
    foreach root $roots {
        #item 2964
        lappend trees \
          [ build_traverse $nodes $edges $root ]
    }
    #item 2985
    return $trees
}

proc base_classes { class } {
    #item 1936
    set result {}
    #item 1938
    set links [ get_class_links $class ]
    foreach link $links {
        #item 1941
        set type [ get_link_type $link ]
        set src [ get_link_src_table $link ]
        #item 1942
        if {($src == $class) && ($type == "inheritance")} {
            #item 1948
            lappend result $link
        } else {
            
        }
    }
    #item 1937
    return $result
}

proc build_aux { } {
    #item 1436
    set classes [ class_name_keys ]
    foreach class $classes {
        #item 1439
        set base [ find_base $class ]
        set derived [ find_derived $class ]
        #item 1440
        if {($base == {}) && ($derived == {})} {
            #item 1444
            set simple 1
        } else {
            #item 1445
            set simple 0
        }
        #item 2314
        lassign \
        [has_ref_count $class] \
        ref_count master_arrow
        #item 1446
        insert_class2 $class $simple $base \
         $derived $ref_count $master_arrow
        #item 1449
        set fields [ get_class_fields $class ]
        foreach field $fields {
            #item 1450
            gen_field_aux $class $field
        }
    }
    foreach class $classes {
        #item 2688
        check_class_inheritance $class
    }
    foreach class $classes {
        #item 2344
        set chain [ inheritance_chain $class ]
        set base [ lindex $chain 0 ]
        set ref_count [ get_class2_has_ref_count $class ]
        #item 2345
        if {$ref_count} {
            #item 2348
            set_class2_has_ref_count $base 1
        } else {
            
        }
    }
}

proc build_classes { } {
    #item 847
    set vertex_ids [ vertex_type_keys ]
    foreach vertex_id $vertex_ids {
        #item 852
        set type [ get_vertex_type $vertex_id ]
        #item 8530001
        if {$type == "action"} {
            #item 863
            add_class_declaration $vertex_id
        } else {
            #item 8530002
            if {$type == "shelf"} {
                #item 864
                add_class_definition $vertex_id
            } else {
                
            }
        }
    }
}

proc build_connections { } {
    #item 226
    set vertexes \
    [actions_and_shelves]
    foreach vertex_id $vertexes {
        #item 229
        set right \
        [get_vertex_right $vertex_id]
        #item 232
        set down \
        [get_vertex_down $vertex_id]
        #item 589
        set in_head {}
        #item 595
        set con \
        [make_con $vertex_id {} $in_head {}]
        #item 233
        con_hor_begin $right $con
        #item 234
        con_ver_begin $down $con
    }
}

proc build_indexes { } {
    #item 1324
    set ids [ index_info_data_keys ]
    foreach id $ids {
        #item 1327
        set class_id [ get_index_info_class_id $id ]
        set data [ get_index_info_data $id ]
        set vertex_id [ get_index_info_vertex $id ]
        #item 1328
        create_index_core $class_id $data $vertex_id
    }
}

proc build_link { connection_id } {
    #item 1091
    set orientation \
    [get_connection_orientation $connection_id]
    #item 1092
    set head \
    [get_connection_head $connection_id]
    #item 1129
    set ovals \
    [get_connection_ovals $connection_id]
    #item 1158
    set vertex1 [ get_connection_vertex1 $connection_id ]
    set vertex2 [ get_connection_vertex2 $connection_id ]
    #item 1159
    set edge [ get_connection_edge $connection_id ]
    #item 1213
    set rovals [ lreverse $ovals ]
    #item 10990001
    if {$orientation == "horizontal"} {
        #item 11060001
        if {$head == "line"} {
            #item 1128
            link_line "none" $edge \
             $vertex1 $vertex2 $ovals
        } else {
            #item 11060002
            if {$head == "arrow"} {
                #item 1132
                link_arrow "none" $edge \
                 $vertex1 $vertex2 $ovals
            } else {
                #item 11060003
                if {$head == "m2m"} {
                    #item 1332
                    link_m2m $edge \
                     $vertex1 $vertex2 $ovals
                } else {
                    #item 11060004
                    if {$head == "paw"} {
                        
                    } else {
                        #item 11060005
                        error "Unexpected switch value: $head"
                    }
                    #item 1133
                    link_paw "none" $edge \
                     $vertex1 $vertex2 $ovals
                }
            }
        }
    } else {
        #item 10990002
        if {$orientation == "vertical"} {
            
        } else {
            #item 10990003
            error "Unexpected switch value: $orientation"
        }
        #item 11170001
        if {$head == "up white arrow"} {
            #item 1135
            link_inherit $edge \
             $vertex2 $vertex1 $rovals
        } else {
            #item 11170002
            if {$head == "up arrow"} {
                #item 1136
                link_arrow "dst" $edge \
                 $vertex2 $vertex1 $rovals
            } else {
                #item 11170003
                if {$head == "down arrow"} {
                    #item 1137
                    link_arrow "src" $edge \
                     $vertex1 $vertex2 $ovals
                } else {
                    #item 11170004
                    if {$head == "line"} {
                        #item 1138
                        link_line "src" $edge \
                         $vertex1 $vertex2 $ovals
                    } else {
                        #item 11170005
                        if {$head == "down paw"} {
                            
                        } else {
                            #item 11170006
                            error "Unexpected switch value: $head"
                        }
                        #item 1139
                        link_paw "src" $edge \
                         $vertex1 $vertex2 $ovals
                    }
                }
            }
        }
    }
}

proc build_links { } {
    #item 1069
    set connections \
    [connection_vertex1_keys]
    foreach connection_id $connections {
        #item 1068
        build_link $connection_id
    }
}

proc build_traverse { nodes edges root_id } {
    #item 2970
    if {$root_id == {}} {
        #item 2973
        return {}
    } else {
        #item 2974
        set node [ dict get $nodes $root_id ]
        #item 2975
        set outgoing [ get_tnode_outgoing $root_id $edges ]
        set children {}
        foreach edge $outgoing {
            #item 2978
            lassign $edge _ _ _ dst
            #item 2979
            set child \
            [build_traverse $nodes $edges $dst]
            #item 2980
            lappend children $child
        }
        #item 2981
        lappend node $children
        #item 2982
        return $node
    }
}

proc build_tree_link { connection_id } {
    #item 2776
    set orientation \
    [get_connection_orientation $connection_id]
    #item 2777
    set head \
    [get_connection_head $connection_id]
    #item 2822
    set vertex1 [ get_connection_vertex1 $connection_id ]
    set vertex2 [ get_connection_vertex2 $connection_id ]
    #item 2823
    set edge [ get_connection_edge $connection_id ]
    #item 27840001
    if {$orientation == "vertical"} {
        #item 27970001
        if {$head == "line"} {
            #item 2816
            link_line "src" $edge \
             $vertex1 $vertex2 {}
        } else {
            #item 27970002
            if {$head == "down paw"} {
                #item 2817
                link_paw "src" $edge \
                 $vertex1 $vertex2 {}
            } else {
                #item 27970003
                if {$head == ""} {
                    
                } else {
                    #item 2826
                    error "Unsupported link type: '$head'"
                }
            }
        }
    } else {
        #item 27840002
        if {$orientation == "horizontal"} {
            
        } else {
            #item 27840003
            error "Unexpected switch value: $orientation"
        }
        #item 2824
        error "Only vertical links are allowed"
    }
}

proc chain_ref_count { chain } {
    foreach $class $chain {
        #item 2328
        if {[get_class2_has_ref_count $class]} {
            #item 2331
            return 1
        } else {
            
        }
    }
    #item 2332
    return 0
}

proc check_class_inheritance { class } {
    #item 1876
    set base_links [ base_classes $class ]
    set base_count [ llength $base_links ]
    #item 1892
    set name [ get_class_name $class ]
    #item 19490001
    if {$base_count == 0} {
        #item 1956
        set base_link {}
    } else {
        #item 19490002
        if {$base_count == 1} {
            #item 1957
            set base_link [ lindex $base_links 0 ]
        } else {
            #item 1959
            set message "Class $name has several base classes."
            #item 1958
            report_error_class $name $message
        }
    }
    #item 1912
    if {($base_link == {}) || (!([find_cycles $base_link [ list $class ]]))} {
        
    } else {
        #item 1919
        set message "Inheritance cycle detected at class $name."
        #item 1918
        report_error_class $name $message
    }
}

proc check_empty_link { id } {
    #item 1406
    set type [ get_empty_link_type $id ]
    set own [ get_empty_link_ownership $id ]
    set src [ get_empty_link_src $id ]
    set dst [ get_empty_link_dst $id ]
    set edge [ get_empty_link_edge $id ]
    #item 1407
    set links [ link_type_keys ]
    
    set normal_1408 1
    foreach link_id $links {
        #item 1410
        set type2 [ get_link_type $link_id ]
        set own2 [ get_link_ownership $link_id ]
        set src2 [ get_link_src_table $link_id ]
        set dst2 [ get_link_dst_table $link_id ]
        #item 1411
        if {((($type == $type2) && ($own == $own2)) && ($src == $src2)) && ($dst == $dst2)} {
            set normal_1408 0
            break
        } else {
            
        }
    }
    if {$normal_1408 == 1} {
        #item 1414
        report_error_edge $edge \
         "Properties for this link are not defined"
    }
}

proc check_hor_ellipse { vertex_id } {
    #item 369
    set right [ get_vertex_right $vertex_id ]
    set up [ get_vertex_up $vertex_id ]
    set down [ get_vertex_down $vertex_id ]
    #item 370
    if {$up == ""} {
        #item 373
        if {$down == ""} {
            #item 376
            if {$right == ""} {
                #item 380
                report_error_vertex $vertex_id
                 "Connector expected to the right"
            } else {
                #item 381
                return $right
            }
        } else {
            #item 804
            report_error_edge $down \
             "Connector not expected"
        }
    } else {
        #item 379
        report_error_edge $up \
         "Connector not expected"
    }
}

proc check_inheritance { } {
    #item 1855
    set links [ link_type_keys ]
    foreach link $links {
        #item 1856
        set type [ get_link_type $link ]
        #item 1857
        if {$type == "inheritance"} {
            #item 1860
            set derived [ get_link_src_table $link ]
            #item 1861
            check_class_inheritance $derived
        } else {
            
        }
    }
}

proc check_links_defined { } {
    #item 1377
    set ids \
    [empty_link_src_keys]
    foreach id $ids {
        #item 1376
        check_empty_link $id
    }
}

proc check_ver_ellipse { vertex_id } {
    #item 792
    set right [ get_vertex_right $vertex_id ]
    set left [ get_vertex_left $vertex_id ]
    set down [ get_vertex_down $vertex_id ]
    #item 793
    if {$left == ""} {
        #item 796
        if {$right == ""} {
            #item 797
            if {$down == ""} {
                #item 800
                report_error_vertex $vertex_id
                 "Connector expected down"
            } else {
                #item 801
                return $down
            }
        } else {
            #item 805
            report_error_edge $right \
             "Connector not expected"
        }
    } else {
        #item 799
        report_error_edge $left \
         "Connector not expected"
    }
}

proc con_hor_begin { edge_id in_con } {
    #item 440
    if {$edge_id == ""} {
        
    } else {
        #item 417
        lassign $in_con vertex1 _ in_head ovals
        #item 245
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 2570001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 418
            set next_head \
            [select_hor_head $edge_id $in_head $head]
            #item 287
            connect $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 2570003
            if {$type2 == "beginend"} {
                #item 306
                ensure_simple_right $edge_id $head
                #item 307
                set next_edge [ check_hor_ellipse $vertex2 ]
                #item 433
                lappend ovals $vertex2
                #item 600
                set next_head \
                [select_hor_head $edge_id $in_head $head]
                #item 288
                set con \
                [make_con $vertex1 {} $next_head $ovals]
                #item 308
                con_hor_begin $next_edge $con
            } else {
                #item 2570004
                if {$type2 == ""} {
                    #item 311
                    ensure_simple_right $edge_id $head
                    #item 309
                    set right [ get_vertex_right $vertex2 ]
                    set up [ get_vertex_up $vertex2 ]
                    set down [ get_vertex_down $vertex2 ]
                    #item 439
                    set next_head \
                    [select_hor_head $edge_id $in_head $head]
                    #item 310
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 312
                    con_hor_up $up $con
                    con_hor_begin $right $con
                    con_hor_down $down $con
                } else {
                    #item 284
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_hor_down { edge_id in_con } {
    #item 530
    if {$edge_id == ""} {
        
    } else {
        #item 529
        lassign $in_con vertex1 _ in_head ovals
        #item 513
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 535
        if {$head == ""} {
            
        } else {
            #item 538
            report_error_edge \
             $edge_id "Simple vertical line expected"
        }
        #item 5140001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 533
            report_error_vertex \
             $vertex2 "Unexpected vertical connection"
        } else {
            #item 5140004
            if {$type2 == ""} {
                #item 527
                set right [ get_vertex_right $vertex2 ]
                set down [ get_vertex_down $vertex2 ]
                #item 528
                con_hor_down $down $in_con
                con_hor_end $right $in_con
            } else {
                #item 524
                report_error_vertex \
                 $vertex2 "Unexpected icon type: $type"
            }
        }
    }
}

proc con_hor_end { edge_id in_con } {
    #item 581
    if {$edge_id == ""} {
        
    } else {
        #item 576
        lassign $in_con vertex1 _ in_head ovals
        #item 552
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 5530001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 577
            set next_head \
            [select_hor_head $edge_id $in_head $head]
            #item 567
            connect $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 5530003
            if {$type2 == "beginend"} {
                #item 569
                ensure_simple_right $edge_id $head
                #item 570
                set next_edge [ check_hor_ellipse $vertex2 ]
                #item 578
                lappend ovals $vertex2
                #item 568
                set con \
                [make_con $vertex1 {} $in_head $ovals]
                #item 571
                con_hor_end $next_edge $con
            } else {
                #item 5530004
                if {$type2 == ""} {
                    #item 574
                    ensure_simple_right $edge_id $head
                    #item 572
                    set right [ get_vertex_right $vertex2 ]
                    #item 584
                    if {$right == ""} {
                        #item 585
                        report_error_edge \
                         $edge_id \
                         "Expected connector to the right"
                    } else {
                        
                    }
                    #item 580
                    set next_head \
                    [select_hor_head $edge_id $in_head $head]
                    #item 573
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 575
                    con_hor_end $right $con
                } else {
                    #item 564
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_hor_up { edge_id in_con } {
    #item 481
    if {$edge_id == ""} {
        
    } else {
        #item 472
        lassign $in_con vertex2 _ in_head ovals
        #item 448
        set head [ get_edge_head $edge_id ]
        set vertex1 [ get_edge_vertex1 $edge_id ]
        set type2 [ get_vertex_type $vertex1 ]
        #item 486
        if {$head == ""} {
            
        } else {
            #item 489
            report_error_edge \
             $edge_id "Simple vertical line expected"
        }
        #item 4490001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 484
            report_error_vertex \
             $vertex1 "Unexpected vertical connection"
        } else {
            #item 4490004
            if {$type2 == ""} {
                #item 468
                set right [ get_vertex_right $vertex1 ]
                set up [ get_vertex_up $vertex1 ]
                #item 490
                if {($right == "") && ($up == "")} {
                    #item 496
                    report_error_edge \
                     $edge_id \
                     "Expected connector up or to the right"
                } else {
                    
                }
                #item 471
                con_hor_up $up $in_con
                con_hor_end $right $in_con
            } else {
                #item 460
                report_error_vertex \
                 $vertex1 "Unexpected icon type: $type2"
            }
        }
    }
}

proc con_ver_begin { edge_id in_con } {
    #item 641
    if {$edge_id == ""} {
        
    } else {
        #item 637
        lassign $in_con vertex1 _ in_head ovals
        #item 613
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 6140001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 638
            set next_head \
            [select_ver_head $edge_id $in_head $head]
            #item 628
            connect_ver $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 6140003
            if {$type2 == "beginend"} {
                #item 630
                ensure_simple_down $edge_id $head
                #item 631
                set next_edge [ check_ver_ellipse $vertex2 ]
                #item 639
                lappend ovals $vertex2
                #item 644
                set next_head \
                [select_ver_head $edge_id $in_head $head]
                #item 629
                set con \
                [make_con $vertex1 {} $next_head $ovals]
                #item 632
                con_ver_begin $next_edge $con
            } else {
                #item 6140004
                if {$type2 == ""} {
                    #item 635
                    ensure_simple_down $edge_id $head
                    #item 633
                    set right [ get_vertex_right $vertex2 ]
                    set left [ get_vertex_left $vertex2 ]
                    set down [ get_vertex_down $vertex2 ]
                    #item 640
                    set next_head \
                    [select_ver_head $edge_id $in_head $head]
                    #item 634
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 636
                    con_ver_left $left $con
                    con_ver_right $right $con
                    con_ver_begin $down $con
                } else {
                    #item 625
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_ver_end { edge_id in_con } {
    #item 780
    if {$edge_id == ""} {
        
    } else {
        #item 776
        lassign $in_con vertex1 _ in_head ovals
        #item 752
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 7530001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 777
            set next_head \
            [select_ver_head $edge_id $in_head $head]
            #item 767
            connect_ver $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 7530003
            if {$type2 == "beginend"} {
                #item 769
                ensure_simple_down $edge_id $head
                #item 770
                set next_edge [ check_ver_ellipse $vertex2 ]
                #item 778
                lappend ovals $vertex2
                #item 768
                set con \
                [make_con $vertex1 {} $in_head $ovals]
                #item 771
                con_ver_end $next_edge $con
            } else {
                #item 7530004
                if {$type2 == ""} {
                    #item 774
                    ensure_simple_down $edge_id $head
                    #item 772
                    set down [ get_vertex_down $vertex2 ]
                    #item 783
                    if {$down == ""} {
                        #item 784
                        report_error_edge \
                         $edge_id \
                         "Expected connector down"
                    } else {
                        
                    }
                    #item 779
                    set next_head \
                    [select_ver_head $edge_id $in_head $head]
                    #item 773
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 775
                    con_ver_end $down $con
                } else {
                    #item 764
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_ver_left { edge_id in_con } {
    #item 700
    if {$edge_id == ""} {
        
    } else {
        #item 699
        lassign $in_con vertex2 _ in_head ovals
        #item 683
        set head [ get_edge_head $edge_id ]
        set vertex1 [ get_edge_vertex1 $edge_id ]
        set type2 [ get_vertex_type $vertex1 ]
        #item 705
        if {$head == ""} {
            
        } else {
            #item 708
            report_error_edge \
             $edge_id "Simple horizontal line expected"
        }
        #item 6840001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 703
            report_error_vertex \
             $vertex1 "Unexpected horizontal connection"
        } else {
            #item 6840004
            if {$type2 == ""} {
                #item 697
                set down [ get_vertex_down $vertex1 ]
                set left [ get_vertex_left $vertex1 ]
                #item 709
                if {($left == "") && ($down == "")} {
                    #item 715
                    report_error_edge \
                     $edge_id \
                     "Expected connector down or to the left"
                } else {
                    
                }
                #item 698
                con_ver_left $left $in_con
                con_ver_end $down $in_con
            } else {
                #item 694
                report_error_vertex \
                 $vertex1 "Unexpected icon type: $type2"
            }
        }
    }
}

proc con_ver_right { edge_id in_con } {
    #item 738
    if {$edge_id == ""} {
        
    } else {
        #item 737
        lassign $in_con vertex1 _ in_head ovals
        #item 721
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 743
        if {$head == ""} {
            
        } else {
            #item 746
            report_error_edge \
             $edge_id "Simple horizontal line expected"
        }
        #item 7220001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 741
            report_error_vertex \
             $vertex2 "Unexpected horizontal connection"
        } else {
            #item 7220004
            if {$type2 == ""} {
                #item 735
                set right [ get_vertex_right $vertex2 ]
                set down [ get_vertex_down $vertex2 ]
                #item 736
                con_ver_end $down $in_con
                con_ver_right $right $in_con
            } else {
                #item 732
                report_error_vertex \
                 $vertex2 "Unexpected icon type: $type"
            }
        }
    }
}

proc connect { vertex1 vertex2 head ovals edge } {
    #item 3400001
    if {$head == "left paw"} {
        #item 347
        set out_head "paw"
        #item 351
        set out_ovals [ lreverse $ovals ]
        #item 353
        set out_vertex1 $vertex2
        set out_vertex2 $vertex1
    } else {
        #item 3400002
        if {$head == "left arrow"} {
            #item 348
            set out_head "arrow"
            #item 351
            set out_ovals [ lreverse $ovals ]
            #item 353
            set out_vertex1 $vertex2
            set out_vertex2 $vertex1
        } else {
            #item 3400003
            if {$head == "right paw"} {
                #item 358
                set out_head "paw"
            } else {
                #item 3400004
                if {$head == "right arrow"} {
                    #item 359
                    set out_head "arrow"
                } else {
                    #item 3400005
                    if {$head == "m2m"} {
                        #item 606
                        set out_head "m2m"
                    } else {
                        #item 3400006
                        if {$head == ""} {
                            
                        } else {
                            #item 3400007
                            error "Unexpected switch value: $head"
                        }
                        #item 362
                        set out_head "line"
                    }
                }
            }
            #item 352
            set out_ovals $ovals
            #item 354
            set out_vertex1 $vertex1
            set out_vertex2 $vertex2
        }
    }
    #item 363
    set id [ connection_next_id ]
    #item 334
    insert_connection \
    	$id \
    	$out_vertex1 \
    	$out_vertex2 \
    	"horizontal" \
    	$out_head \
    	$out_ovals \
    	$edge
}

proc connect_ver { vertex1 vertex2 head ovals edge } {
    #item 841
    if {$head == ""} {
        #item 844
        set head "line"
    } else {
        
    }
    #item 674
    set id [ connection_next_id ]
    #item 650
    insert_connection \
    	$id \
    	$vertex1 \
    	$vertex2 \
    	"vertical" \
    	$head \
    	$ovals \
    	$edge
}

proc core_can_delete { class } {
    #item 2469
    set body {}
    #item 2454
    set fields [ get_class_fields $class ]
    foreach field $fields {
        #item 2457
        set type [ get_field2_type $field ]
        #item 2458
        if {$type == "collection"} {
            #item 2461
            set link [ get_field2_link $field ]
            set own [ get_link_ownership $link ]
            set link_type [ get_link_type $link ]
            #item 2610
            if {($link_type == "paw") && ($own == "none")} {
                #item 2467
                set dst [ get_link_dst_table $link ]
                #item 2468
                set action [ list \
                 "action" "ensure_deleted" "field" $field \
                 "class" $dst ]
                #item 2466
                set check [ list \
                 "foreach" [ list "field" $field ] \
                 "do" $action ]
                #item 2470
                lappend body $check
            } else {
                
            }
        } else {
            
        }
    }
    #item 2471
    set head [ list "proc" "can_delete" "body" $body ]
    #item 2472
    return $head
}

proc core_classes_table { } {
    #item 1982
    set names {}
    #item 1976
    set classes [ class_name_keys ]
    foreach class $classes {
        #item 1980
        set name [ get_class_name $class ]
        lappend names $name
    }
    #item 1983
    set sorted [ lsort $names ]
    #item 1988
    set tables {}
    foreach name $sorted {
        #item 1986
        set class [ find_class $name ]
        lappend tables [ list $class $name ]
    }
    #item 1987
    return $tables
}

proc core_debug_print { output field_selector } {
    #item 2011
    set classes [ core_classes_table ]
    #item 2036
    puts $output "classes:"
    #item 2037
    print_list $classes $output
    foreach cls $classes {
        #item 2038
        lassign $cls class name
        #item 2039
        puts $output ""
        puts $output "class $name"
        #item 2040
        print_proc [ core_insert $class $field_selector ]
        #item 2041
        print_proc [ core_delete $class ]
        #item 2270
        set fields [ get_class_fields $class ]
        foreach field $fields {
            #item 2042
            set chunk [ core_update $field ]
            #item 2271
            if {$chunk == ""} {
                
            } else {
                #item 2274
                print_proc $chunk
            }
        }
        #item 2043
        print_proc \
         [ core_insert_possible $class $field_selector ]
        print_proc \
         [ core_pre_delete_outer $class ]
        print_proc \
         [ core_pre_delete_middle $class ]
        print_proc \
         [ core_pre_delete_inner $class ]
        print_proc \
         [ core_can_delete $class ]
        print_proc \
         [ core_do_delete $class ]
    }
}

proc core_delete { class } {
    #item 2003
    set body {}
    #item 2394
    set master [ get_class2_master_arrow $class ]
    #item 2395
    if {$master} {
        #item 2398
        set mvalue "false"
    } else {
        #item 2397
        set mvalue "none"
    }
    #item 2538
    lappend body \
     [ list "action" "check_self" "class" $class ]
    #item 2393
    lappend body [ list \
     "action" "pre_delete_outer" \
     "class" $class "field_name" "id" "master" $mvalue ]
    #item 2005
    lappend body \
     [ list "foreach" { "variable" "del_list" } \
     "do" { "action" "can_delete" } ]
    #item 2400
    lappend body \
     [ list "foreach" { "variable" "del_list" } \
     "do" { "action" "do_delete" } ]
    #item 2401
    set head [ list "proc" "delete" "body" $body ]
    #item 2402
    return $head
}

proc core_delete_body { class } {
    #item 2641
    set body {}
    #item 2640
    set fields [ get_class_fields $class ]
    set indexes [ get_class_indexes $class ]
    foreach field $fields {
        #item 2649
        set type [ get_field2_type $field ]
        #item 26640001
        if {$type == "reference"} {
            #item 2651
            set link [ get_field2_link $field ]
            set target [ get_target $link ]
            #item 2653
            set op [ get_connect_type $field ]
            #item 2652
            lappend body \
             [ list "action" "disconnect" "op" $op \
             "field" $field "link" $link "target" $target]
        } else {
            #item 26640002
            if {$type == "collection"} {
                #item 2671
                set link [ get_field2_link $field ]
                set link_type [ get_link_type $link ]
                #item 2672
                if {$link_type == "m2m"} {
                    #item 2675
                    lassign \
                    [get_other_side $field] \
                    target_class target_field
                    #item 2674
                    set action \
                     [ list "action" "disconnect_m2m" \
                     "field" $field "target_field" $target_field]
                    #item 2673
                    lappend body [ list \
                     "foreach" [ list "field" $field ] \
                     "do" $action ]
                } else {
                    
                }
            } else {
                
            }
        }
    }
    foreach index $indexes {
        #item 2663
        set i_fields [ index_fields $index ]
        lappend body \
         [ list "action" "remove_from_index" \
         "index" $index \
         "fields" $i_fields ]
    }
    #item 2656
    return $body
}

proc core_do_delete { class } {
    #item 2676
    set chain [ inheritance_chain $class ]
    set chain [ lreverse $chain ]
    #item 2481
    set body {}
    foreach cls $chain {
        #item 2679
        set part [ core_delete_body $cls ]
        set body [ concat $body $part ]
        #item 2478
        set fields [ get_class_fields $class ]
        set indexes [ get_class_indexes $class ]
    }
    #item 2682
    set head \
     [ list "proc" "do_delete" "body" $body ]
    #item 2681
    return $head
}

proc core_insert { class fields_selector } {
    #item 1641
    set body {}
    #item 1636
    set chain [ inheritance_chain $class ]
    set indexed {}
    set all_fields {}
    foreach cls $chain {
        #item 1639
        set fields [ select_fields $cls $fields_selector ]
        #item 1640
        set all_fields [ concat $all_fields $fields ]
        dict append indexed $cls $fields
    }
    #item 1642
    set root [ lindex $chain 0 ]
    lappend body [ list \
     "action" "check_id" "class" $root ]
    foreach cls $chain {
        #item 1737
        set fields [ dict get $indexed $cls ]
        #item 1739
        lappend body \
         [ list "action" "insert_possible" \
         "class" $cls \
         "fields" $fields ]
    }
    #item 1644
    lappend body \
     [ list "action" "assemble" \
     "indexed" $indexed \
     "all" $all_fields ]
    foreach cls $chain {
        #item 1653
        set indexes [ get_class_indexes $cls ]
        foreach index $indexes {
            #item 1654
            set i_fields [ index_fields $index ]
            lappend body \
             [ list "action" "add_to_index" \
             "index" $index \
             "fields" $i_fields ]
        }
    }
    foreach field $all_fields {
        #item 2263
        set op [ get_connect_type $field ]
        set link [ get_field2_link $field ]
        #item 1674
        if {$op == ""} {
            
        } else {
            #item 1688
            lappend body \
             [ list "action" "connect" \
             "op" $op \
             "field" $field \
             "link" $link ]
        }
    }
    #item 2103
    set head \
     [ list "proc" "insert" "args" $all_fields "body" $body ]
    #item 1670
    return $head
}

proc core_insert_possible { class fields_selector } {
    #item 1704
    set body {}
    #item 1703
    set fields [ select_fields $class $fields_selector ]
    #item 1705
    set head \
     [ list "proc" "insert_possible" "args" $fields ]
    #item 1706
    set indexes [ get_class_indexes $class ]
    foreach index $indexes {
        #item 2100
        set ifields [ index_fields $index ]
        #item 1709
        lappend body \
         [ list "action" "index_not_exists" \
         "index" $index \
         "fields" $ifields "changed" "" ]
    }
    foreach field $fields {
        #item 1713
        set type [ get_field2_type $field ]
        #item 1714
        if {$type == "reference"} {
            #item 1717
            set link [ get_field2_link $field ]
            #item 2607
            lappend body \
            [ make_foreign_check $field $link "insert" ]
        } else {
            
        }
    }
    #item 2101
    lappend head "body" $body
    #item 2102
    return $head
}

proc core_pre_delete_inner { class } {
    #item 2378
    set body {}
    #item 2356
    set fields [ get_class_fields $class ]
    foreach field $fields {
        #item 2359
        set link [ get_field2_link $field ]
        set own [ get_link_ownership $link ]
        set link_type [ get_link_type $link ]
        set src [ get_link_src_field $link ]
        set dst_table [ get_link_dst_table $link ]
        set field_name [ get_field_name $field ]
        #item 2367
        if {($own == "src") && ($field_name == $src)} {
            #item 23700001
            if {$link_type == "arrow"} {
                #item 2379
                set action [ list \
                 "action" "pre_delete_outer" \
                 "class" $dst_table "field_name" $field_name \
                 "master" "true" ]
                #item 2380
                set check [ list \
                 "if" [ list "field_not_null" $field ] \
                 "then" $action ]
                #item 2390
                lappend body $check
            } else {
                #item 23700002
                if {$link_type == "paw"} {
                    #item 2382
                    set master [ get_class2_master_arrow $dst_table ]
                    #item 2383
                    if {$master} {
                        #item 2387
                        set mvalue "false"
                    } else {
                        #item 2386
                        set mvalue "none"
                    }
                    #item 2381
                    set action [ list \
                     "action" "pre_delete_outer" \
                     "class" $dst_table "field_name" "that" \
                     "master" $mvalue ]
                    #item 2388
                    set check [ list \
                     "foreach" [ list "field" $field ] \
                     "do" $action ]
                    #item 2390
                    lappend body $check
                } else {
                    
                }
            }
        } else {
            
        }
    }
    #item 2509
    set head [ list "proc" "pre_delete_inner" \
     "body" $body ]
    #item 2510
    return $head
}

proc core_pre_delete_middle { class } {
    #item 2292
    set chain [ inheritance_chain $class ]
    set base [ lindex $chain 0 ]
    foreach cls $chain {
        #item 2295
        lappend body [ list \
         "action" "pre_delete_inner" \
         "class" $cls ]
    }
    #item 2349
    set head [ list "proc" "pre_delete_middle" \
     "body" $body ]
    #item 2350
    return $head
}

proc core_pre_delete_outer { class } {
    #item 2280
    set chain [ inheritance_chain $class ]
    set base [ lindex $chain 0 ]
    set ref_count [ get_class2_has_ref_count $base ]
    set master_arrow [ get_class2_master_arrow $class ]
    #item 2281
    set body {}
    #item 2282
    lappend body [ list \
     "action" "get_class_id" "class" $base ]
    #item 2283
    lappend body [ list \
     "action" "check_deleted" "class" $base ]
    #item 2333
    if {$ref_count} {
        #item 2315
        lappend body [ list \
         "action" "check_ref_count" \
         "class" $base "master" $master_arrow ]
    } else {
        
    }
    #item 2284
    lappend body [ list \
     "action" "pre_delete_middle" \
     "class" $class ]
    #item 2285
    set head [ list "proc" "pre_delete_outer" \
     "master" $master_arrow "body" $body ]
    #item 2286
    return $head
}

proc core_update { field } {
    #item 1755
    set type [ get_field2_type $field ]
    set indexes [ get_field2_indexes $field ]
    set link [ get_field2_link $field ]
    set class [ get_field_class $field ]
    #item 1756
    set head {}
    #item 1763
    if {$type == "collection"} {
        
    } else {
        #item 2104
        lappend head \
         "proc" "setter" "class" $class \
         "field" $field "args" {}
        #item 1758
        if {($indexes == {}) && ($type == "data")} {
            #item 2105
            lappend head "type" "simple"
        } else {
            #item 1771
            lappend head "type" "complex"
            set body {}
            #item 1778
            lappend body \
             [ list "action" "check_self" "class" $class ]
            #item 2539
            lappend body \
             [ list "action" "check_change" "field" $field ]
            #item 2543
            set fields [ get_class_fields $class ]
            foreach other $fields {
                #item 2546
                if {$other == $field} {
                    
                } else {
                    #item 2550
                    set f_indexes [ get_field2_indexes $other ]
                    #item 2551
                    if {[indexes_contain_field $f_indexes $field]} {
                        #item 2549
                        lappend body \
                         [ list "action" "fetch_field" "field" $other ]
                    } else {
                        
                    }
                }
            }
            foreach index $indexes {
                #item 1793
                set ifields [ index_fields $index ]
                #item 2552
                if {[contains $ifields $field]} {
                    #item 1792
                    set old [ remove $ifields $field ]
                    #item 2106
                    lappend body \
                     [ list "action" "index_not_exists" \
                     "index" $index "fields" $ifields \
                     "changed" $field ]
                } else {
                    
                }
            }
            #item 1794
            if {$link == {}} {
                
            } else {
                #item 2606
                lappend body \
                [ make_foreign_check $field $link "update" ]
            }
            #item 1809
            if {$link == {}} {
                
            } else {
                #item 2265
                set op [ get_connect_type $field ]
                set target [ get_target $link ]
                #item 2264
                if {$op == ""} {
                    
                } else {
                    #item 1824
                    lappend body \
                     [ list "action" "disconnect_old" \
                     "op" $op "field" $field \
                     "link" $link "target" $target ]
                }
            }
            foreach index $indexes {
                #item 1828
                set ifields [ index_fields $index ]
                #item 2555
                if {[contains $ifields $field]} {
                    #item 1827
                    lappend body \
                     [ list "action" "remove_from_index_old" \
                     "index" $index "fields" $ifields \
                     "old" $field ]
                } else {
                    
                }
            }
            #item 1829
            lappend body \
             [ list "action" "replace" \
             "class" $class "field" $field ]
            foreach index $indexes {
                #item 1833
                set ifields [ index_fields $index ]
                #item 2558
                if {[contains $ifields $field]} {
                    #item 1832
                    set old [ remove $ifields $field ]
                    #item 2107
                    lappend body \
                     [ list "action" "add_to_index" \
                     "index" $index "fields" $ifields ]
                } else {
                    
                }
            }
            #item 1834
            if {$link == {}} {
                
            } else {
                #item 2267
                set op [ get_connect_type $field ]
                #item 2266
                if {$op == ""} {
                    
                } else {
                    #item 2108
                    lappend body \
                     [ list "action" "connect" \
                     "op" $op \
                     "field" $field \
                     "link" $link ]
                }
            }
            #item 2109
            lappend head "body" $body
        }
    }
    #item 1757
    return $head
}

proc create_field { class_id begin_parts end_parts vertex_id } {
    #item 1003
    set name [ lindex $begin_parts 0 ]
    #item 2689
    if {[ string tolower $name ] == "id"} {
        #item 2691
        report_error_vertex $vertex_id \
          "'id' is not allowed as a field name"
    } else {
        #item 1004
        set existing [ find_field $class_id $name ]
        #item 1005
        if {$existing == ""} {
            #item 1009
            add_field $name $end_parts $class_id
        } else {
            #item 1008
            report_error_vertex $vertex_id \
              "Field $name already defined"
        }
    }
}

proc create_index { class_id index vertex_id } {
    #item 1319
    set id [ index_info_next_id ]
    #item 1316
    insert_index_info $id $class_id $index $vertex_id
}

proc create_index_core { class_id index vertex_id } {
    #item 1015
    lassign $index begin end
    #item 1016
    set first [ lindex $begin 0 ]
    set fields [ lrange $begin 1 end ]
    #item 1017
    if {$first == "index"} {
        #item 1032
        if {[has_repeating $fields]} {
            #item 1035
            report_error_vertex $vertex_id \
             "Repeating fields in index"
        } else {
            
            set normal_1036 1
            foreach field $fields {
                #item 1038
                set field_id [ find_field $class_id $field ]
                #item 1039
                if {$field_id == ""} {
                    #item 1041
                    report_error_vertex $vertex_id \
                     "Indexed field $field not found in class"
                    set normal_1036 0
                    break
                } else {
                    
                }
                #item 1350
                if {[ is_collection $field_id ]} {
                    #item 1352
                    report_error_vertex $vertex_id \
                     "Indexed field $field is a collection"
                    set normal_1036 0
                    break
                } else {
                    
                }
            }
            if {$normal_1036 == 1} {
                #item 1044
                set class_name [ get_class_name $class_id ]
                
                set index_name "${class_name}_[ join $fields "_" ]"
                #item 1043
                add_index $class_id $index_name $end $fields
            }
        }
    } else {
        #item 1020
        report_error_vertex $vertex_id \
         "'index' keyword expected"
    }
}

proc ensure_no_fields_reuse { class_id field_name edge } {
    #item 1205
    if {$field_name == ""} {
        
    } else {
        #item 1190
        set field [ find_field $class_id $field_name ]
        #item 1191
        if {$field == ""} {
            #item 1194
            add_field $field_name {link} $class_id
            #item 1166
            set class_links [ get_class_links $class_id ]
            foreach link_id $class_links {
                #item 1169
                set src_table [ get_link_src_table $link_id ]
                set dst_table [ get_link_dst_table $link_id ]
                set src_field [ get_link_src_field $link_id ]
                set dst_field [ get_link_dst_field $link_id ]
                #item 1170
                if {(($src_table == $class_id) && ($src_field == $field_name)) || (($dst_table == $class_id) && ($dst_field == $field_name))} {
                    #item 1180
                    report_error_edge $edge \
                     "Field $field_name is already used for another link"
                    break
                } else {
                    
                }
            }
        } else {
            #item 1195
            set props [ get_field_properties $field ]
            #item 1196
            if {$props == {}} {
                #item 1199
                set_field_properties $field {link}
                #item 1166
                set class_links [ get_class_links $class_id ]
                foreach link_id $class_links {
                    #item 1169
                    set src_table [ get_link_src_table $link_id ]
                    set dst_table [ get_link_dst_table $link_id ]
                    set src_field [ get_link_src_field $link_id ]
                    set dst_field [ get_link_dst_field $link_id ]
                    #item 1170
                    if {(($src_table == $class_id) && ($src_field == $field_name)) || (($dst_table == $class_id) && ($dst_field == $field_name))} {
                        #item 1180
                        report_error_edge $edge \
                         "Field $field_name is already used for another link"
                        break
                    } else {
                        
                    }
                }
            } else {
                #item 1202
                set first [ lindex $props 0 ]
                #item 1200
                if {$first == "link"} {
                    #item 1166
                    set class_links [ get_class_links $class_id ]
                    foreach link_id $class_links {
                        #item 1169
                        set src_table [ get_link_src_table $link_id ]
                        set dst_table [ get_link_dst_table $link_id ]
                        set src_field [ get_link_src_field $link_id ]
                        set dst_field [ get_link_dst_field $link_id ]
                        #item 1170
                        if {(($src_table == $class_id) && ($src_field == $field_name)) || (($dst_table == $class_id) && ($dst_field == $field_name))} {
                            #item 1180
                            report_error_edge $edge \
                             "Field $field_name is already used for another link"
                            break
                        } else {
                            
                        }
                    }
                } else {
                    #item 1204
                    report_error_edge $edge \
                     "Field $field_name is not a link"
                }
            }
        }
    }
}

proc ensure_simple_down { edge_id head } {
    #item 8130001
    if {((($head == "up arrow") || ($head == "up white arrow")) || ($head == "up paw")) || ($head == "")} {
        
    } else {
        #item 821
        report_error_edge \
         $edge_id "Unexpected line ending: $head"
    }
}

proc ensure_simple_right { edge_id head } {
    #item 2940001
    if {(($head == "left arrow") || ($head == "left paw")) || ($head == "")} {
        
    } else {
        #item 303
        report_error_edge \
         $edge_id "Unexpected right line ending: $head"
    }
}

proc find_base { class } {
    #item 1456
    set links [ get_class_links $class ]
    foreach link $links {
        #item 1459
        set type [ get_link_type $link ]
        set src [ get_link_src_table $link ]
        #item 1460
        if {($type == "inheritance") && ($src == $class)} {
            #item 1463
            set dst [ get_link_dst_table $link ]
            #item 1464
            return $dst
        } else {
            
        }
    }
    #item 1465
    return {}
}

proc find_class { name } {
    #item 146
    set key [ string tolower $name ]
    #item 147
    set id [ get_class_by_name_class $key ]
    #item 148
    return $id
}

proc find_cycles { link traversed } {
    #item 1925
    set dst [ get_link_dst_table $link ]
    #item 1926
    if {[contains $traversed $dst]} {
        #item 1929
        return 1
    } else {
        #item 1930
        lappend traversed $dst
    }
    #item 1961
    set base_links [ base_classes $dst ]
    foreach base_link $base_links {
        #item 1964
        if {[find_cycles $base_link $traversed]} {
            #item 1967
            return 1
        } else {
            
        }
    }
    #item 1968
    return 0
}

proc find_derived { class } {
    #item 1485
    set result {}
    #item 1480
    set classes [ class_name_keys ]
    foreach other_class $classes {
        #item 1483
        set base [ find_base $other_class ]
        #item 1487
        if {$base == $class} {
            #item 1490
            lappend result $other_class
        } else {
            
        }
    }
    #item 1486
    return $result
}

proc find_field { class_id name } {
    #item 144
    set key [ make_field_key $class_id $name ]
    #item 120
    set id [ get_field_by_name_field $key ]
    #item 121
    return $id
}

proc gen_field_aux { class field } {
    #item 1508
    set name [ get_field_name $field ]
    set incoming {}
    set outgoing {}
    #item 1505
    set links [ get_class_links $class ]
    foreach link $links {
        #item 1509
        set dst_table [ get_link_dst_table $link ]
        set src_table [ get_link_src_table $link ]
        set dst_field [ get_link_dst_field $link ]
        set src_field [ get_link_src_field $link ]
        #item 1510
        if {$src_table == $class} {
            #item 1516
            if {$src_field == $name} {
                #item 1519
                set outgoing $link
            } else {
                #item 2725
                if {$dst_field == $name} {
                    #item 2727
                    set incoming $link
                } else {
                    
                }
            }
        } else {
            #item 1513
            if {($dst_table == $class) && ($dst_field == $name)} {
                #item 1520
                set incoming $link
            } else {
                
            }
        }
    }
    #item 1521
    if {$outgoing == {}} {
        #item 1525
        if {$incoming == {}} {
            #item 1549
            set type "data"
        } else {
            #item 1528
            set link_type [ get_link_type $incoming ]
            #item 15390001
            if {$link_type == "paw"} {
                #item 1547
                set type "reference"
            } else {
                #item 15390002
                if {$link_type == "m2m"} {
                    #item 1570
                    set type "collection"
                } else {
                    #item 15390003
                    if {$link_type == "line"} {
                        #item 1575
                        set type "reference"
                    } else {
                        #item 1548
                        set type "data"
                    }
                }
            }
        }
    } else {
        #item 1524
        set link_type [ get_link_type $outgoing ]
        #item 15290001
        if {$link_type == "paw"} {
            #item 1536
            set type "collection"
        } else {
            #item 15290002
            if {$link_type == "arrow"} {
                #item 1537
                set type "reference"
            } else {
                #item 15290003
                if {$link_type == "m2m"} {
                    #item 1567
                    set type "collection"
                } else {
                    #item 15290004
                    if {$link_type == "line"} {
                        #item 1578
                        set type "reference"
                    } else {
                        #item 1538
                        set type "data"
                    }
                }
            }
        }
    }
    #item 1557
    set indexed_by {}
    #item 1553
    set indexes [ get_class_indexes $class ]
    foreach index $indexes {
        #item 1556
        set ifields [ get_index_fields $index ]
        foreach ifield $ifields {
            #item 1560
            if {$ifield == $name} {
                #item 1563
                lappend indexed_by $index
                break
            } else {
                
            }
        }
    }
    #item 2245
    if {$incoming == {}} {
        #item 2248
        set link $outgoing
    } else {
        #item 2249
        set link $incoming
    }
    #item 1564
    insert_field2 $field $type \
     $link $incoming $outgoing $indexed_by
}

proc generate_tables { dbase callbacks after_connections } {
    #item 70
    reset_db
    #item 1045
    set diagrams [ $dbase eval {
    	select diagram_id
    	from diagrams
    } ]
    foreach diagram_id $diagrams {
        #item 1048
        if {[mwc::is_drakon $diagram_id]} {
            
        } else {
            #item 1051
            add_diagram $dbase $diagram_id
        }
    }
    #item 77
    #print_diagram
    #print_vertex
    #print_edge
    #item 183
    build_connections
    #item 1052
    if {$after_connections} {
        
    } else {
        #item 184
        build_classes
        #item 185
        build_links
        #item 1329
        build_indexes
        #item 1373
        check_links_defined
        #item 1431
        build_aux
    }
    #item 1565
    #print_class
    #print_class2
    #print_field
    #print_field2
    #print_link
}

proc generate_trees { dbase } {
    #item 2742
    reset_db
    #item 2747
    set diagrams [ $dbase eval {
    	select diagram_id
    	from diagrams
    } ]
    foreach diagram_id $diagrams {
        #item 2750
        if {[mwc::is_drakon $diagram_id]} {
            
        } else {
            #item 2753
            add_diagram $dbase $diagram_id
        }
    }
    #item 2743
    #print_diagram
    #print_vertex
    #print_edge
    #item 2744
    build_connections
    #item 2762
    set connections \
    [connection_vertex1_keys]
    foreach connection_id $connections {
        #item 2761
        build_tree_link $connection_id
    }
    #item 2827
    set nodes \
    [get_tree_nodes]
    #item 2828
    set edges \
    [get_tree_edges]
    #item 2877
    set trees [ assemble_trees $nodes $edges ]
    #item 2760
    return $trees
}

proc get_collection_target { field link } {
    #item 2711
    set type [ get_link_type $link ]
    #item 27120001
    if {$type == "paw"} {
        #item 2724
        set target [ get_link_dst_table $link ]
    } else {
        #item 27120002
        if {$type == "m2m"} {
            
        } else {
            #item 27120003
            error "Unexpected switch value: $type"
        }
        #item 2717
        set class [ get_field_class $field ]
        set src [ get_link_src_table $link ]
        set dst [ get_link_dst_table $link ]
        #item 2718
        if {$class == $src} {
            #item 2721
            set target $dst
        } else {
            #item 2722
            set target $src
        }
    }
    #item 2723
    return $target
}

proc get_connect_type { field } {
    #item 2208
    set type [ get_field2_type $field ]
    set link [ get_field2_link $field ]
    #item 2215
    set link_type [ get_link_type $link ]
    #item 2209
    if {$type == "reference"} {
        #item 22500001
        if {$link_type == "paw"} {
            #item 2240
            set op "collection"
        } else {
            #item 22500002
            if {$link_type == "arrow"} {
                #item 2241
                set op "ref_count"
            } else {
                #item 2258
                set op ""
            }
        }
    } else {
        #item 2258
        set op ""
    }
    #item 2261
    return $op
}

proc get_other_side { field } {
    #item 2628
    set link [ get_field2_link $field ]
    set field_name [ get_field_name $field ]
    set src_field_name [ get_link_src_field $link ]
    set dst_field_name [ get_link_dst_field $link ]
    #item 2629
    if {$field_name == $src_field_name} {
        #item 2632
        set other_class [ get_link_dst_table $link ]
        set other_field [ find_field $other_class $dst_field_name ]
    } else {
        #item 2633
        set other_class [ get_link_src_table $link ]
        set other_field [ find_field $other_class $src_field_name ]
    }
    #item 2634
    return [ list $other_class $other_field ]
}

proc get_target { link } {
    #item 2608
    set type [ get_link_type $link ]
    #item 25950001
    if {$type == "arrow"} {
        #item 2601
        set target [ get_link_dst_table $link ]
    } else {
        #item 25950002
        if {$type == "paw"} {
            
        } else {
            #item 25950003
            error "Unexpected switch value: $type"
        }
        #item 2602
        set target [ get_link_src_table $link ]
    }
    #item 2603
    return $target
}

proc get_tnode_incoming { node_id edges } {
    #item 2945
    set result {}
    foreach edge $edges {
        #item 2949
        lassign $edge id type src dst
        #item 2950
        if {$node_id == $dst} {
            #item 2953
            lappend result $edge
        } else {
            
        }
    }
    #item 2946
    return $result
}

proc get_tnode_outgoing { node_id edges } {
    #item 2931
    set result {}
    foreach edge $edges {
        #item 2935
        lassign $edge id type src dst
        #item 2936
        if {$node_id == $src} {
            #item 2939
            lappend result $edge
        } else {
            
        }
    }
    #item 2932
    return $result
}

proc get_tnode_text { node } {
    #item 2914
    lassign $node \
     _ type header text
    #item 29150001
    if {$type == "action"} {
        #item 2920
        return $text
    } else {
        #item 29150002
        if {$type == "shelf"} {
            
        } else {
            #item 29150003
            error "Unexpected switch value: $type"
        }
        #item 2922
        return $header
    }
}

proc get_tree_edges { } {
    #item 2833
    set result {}
    #item 2834
    set links \
    [empty_link_type_keys]
    foreach link $links {
        #item 2838
        set type [ get_empty_link_type $link ]
        set src [ get_empty_link_src $link ]
        set dst [ get_empty_link_dst $link ]
        #item 2840
        lappend result [ list \
         $link $type $src $dst ]
    }
    #item 2837
    return $result
}

proc get_tree_nodes { } {
    #item 2844
    set result {}
    #item 2849
    set vertex_ids [ vertex_type_keys ]
    foreach vertex_id $vertex_ids {
        #item 2852
        set type [ get_vertex_type $vertex_id ]
        set text [ get_vertex_text $vertex_id ]
        #item 28530001
        if {$type == "action"} {
            #item 2869
            set header ""
            #item 2866
            set node [ list \
             $vertex_id $type $header $text ]
            #item 2867
            lappend result $vertex_id $node
        } else {
            #item 28530002
            if {$type == "shelf"} {
                #item 2864
                set header [ get_vertex_text2 $vertex_id ]
                #item 2866
                set node [ list \
                 $vertex_id $type $header $text ]
                #item 2867
                lappend result $vertex_id $node
            } else {
                #item 28530003
                if {$type == ""} {
                    
                } else {
                    #item 2863
                    error "Wrong node type: '$type'"
                    break
                }
            }
        }
    }
    #item 2848
    return $result
}

proc get_vertex_class { vertex_id } {
    #item 1295
    set type [ get_vertex_type $vertex_id ]
    #item 12960001
    if {$type == "action"} {
        #item 1304
        set name [ get_vertex_text $vertex_id ]
    } else {
        #item 12960002
        if {$type == "shelf"} {
            
        } else {
            #item 12960003
            error "Unexpected switch value: $type"
        }
        #item 1305
        set text2 [ get_vertex_text2 $vertex_id ]
        #item 1306
        set name [ lindex $text2 1 ]
    }
    #item 1307
    return $name
}

proc has_ref_count { class } {
    #item 2313
    set has_ref_count 0
    set master_arrow 0
    #item 2303
    set links [ get_class_links $class ]
    foreach link $links {
        #item 2304
        set type [ get_link_type $link ]
        set dst [ get_link_dst_table $link ]
        set own [ get_link_ownership $link ]
        #item 2305
        if {($type == "arrow") && ($dst == $class)} {
            #item 2309
            set has_ref_count 1
            #item 2310
            if {$own == "src"} {
                #item 2311
                set master_arrow 1
            } else {
                
            }
        } else {
            
        }
    }
    #item 2312
    return [ list \
     $has_ref_count $master_arrow ]
}

proc has_repeating { collection } {
    #item 1026
    set unique [ lsort -unique $collection ]
    #item 1027
    if {[ llength $collection ] == [ llength $unique ]} {
        #item 1030
        return 0
    } else {
        #item 1031
        return 1
    }
}

proc index_fields { index } {
    #item 2086
    set class [ get_index_class $index ]
    set field_names [ get_index_fields $index ]
    #item 2087
    set result {}
    foreach name $field_names {
        #item 2091
        set field [ find_field $class $name ]
        #item 2092
        lappend result $field
    }
    #item 2088
    return $result
}

proc indexes_contain_field { indexes field } {
    foreach index $indexes {
        #item 2568
        set ifields [ index_fields $index ]
        #item 2569
        if {[contains $ifields $field]} {
            #item 2573
            return 1
        } else {
            
        }
    }
    #item 2572
    return 0
}

proc inheritance_chain { class } {
    #item 2052
    set chain {}
    while { 1 } {
        #item 2049
        lappend chain $class
        #item 2053
        set class [ get_class2_base $class ]
        #item 2051
        if {$class == ""} {
            break
        } else {
            
        }
    }
    #item 2054
    set chain [ lreverse $chain ]
    #item 2055
    return $chain
}

proc is_collection { field_id } {
    #item 1358
    set class_id [ get_field_class $field_id ]
    set name [ get_field_name $field_id ]
    #item 1359
    set links [ link_type_keys ]
    foreach link $links {
        #item 1362
        set src [ get_link_src_table $link ]
        set src_field [ get_link_src_field $link ]
        set type [ get_link_type $link ]
        #item 1363
        if {(($type == "paw") && ($src == $class_id)) && ($src_field == $name)} {
            #item 1370
            return 1
        } else {
            
        }
    }
    #item 1369
    return 0
}

proc is_m2m_field { field } {
    #item 2697
    set link [ get_field2_link $field ]
    #item 2698
    if {$link == {}} {
        #item 2704
        return 0
    } else {
        #item 2701
        set type [ get_link_type $link ]
        #item 2702
        if {$type == "m2m"} {
            #item 2703
            return 1
        } else {
            #item 2704
            return 0
        }
    }
}

proc link_arrow { ownership edge src_table dst_table ovals } {
    #item 1239
    set oval_count [ llength $ovals ]
    #item 12410001
    if {$oval_count == 0} {
        #item 1397
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"arrow" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 12410002
        if {$oval_count == 1} {
            #item 1250
            set src_field [ lindex $ovals 0 ]
            set dst_field ""
            #item 1249
            add_link \
             "arrow" \
             $ownership \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 1248
            report_wrong_ovals $edge
        }
    }
}

proc link_inherit { edge src_table dst_table ovals } {
    #item 1277
    set oval_count [ llength $ovals ]
    #item 12790001
    if {$oval_count == 0} {
        #item 1287
        add_link \
         "inheritance" \
         "none" \
         $src_table \
         $dst_table \
         "" \
         "" \
         $edge
    } else {
        #item 1286
        report_wrong_ovals $edge
    }
}

proc link_line { ownership edge src_table dst_table ovals } {
    #item 1214
    set oval_count [ llength $ovals ]
    #item 12240001
    if {$oval_count == 0} {
        #item 1398
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"line" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 12240002
        if {$oval_count == 2} {
            #item 1233
            lassign $ovals src_field dst_field
            #item 1232
            add_link \
             "line" \
             $ownership \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 1231
            report_wrong_ovals $edge
        }
    }
}

proc link_m2m { edge src_table dst_table ovals } {
    #item 1338
    set oval_count [ llength $ovals ]
    #item 13400001
    if {$oval_count == 0} {
        #item 1399
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"m2m" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 13400002
        if {$oval_count == 2} {
            #item 1349
            lassign $ovals src_field dst_field
            #item 1348
            add_link \
             "m2m" \
             "none" \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 1347
            report_wrong_ovals $edge
        }
    }
}

proc link_paw { ownership edge src_table dst_table ovals } {
    #item 1256
    set oval_count [ llength $ovals ]
    #item 12580001
    if {$oval_count == 0} {
        #item 1400
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"paw" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 12580002
        if {$oval_count == 1} {
            #item 1267
            set src_field [ lindex $ovals 0 ]
            set dst_field ""
            #item 1266
            add_link \
             "paw" \
             $ownership \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 12580003
            if {$oval_count == 2} {
                #item 1270
                lassign $ovals src_field dst_field
                #item 1266
                add_link \
                 "paw" \
                 $ownership \
                 $src_table \
                 $dst_table \
                 $src_field \
                 $dst_field \
                 $edge
            } else {
                #item 1265
                report_wrong_ovals $edge
            }
        }
    }
}

proc make_con { vertex1 vertex2 head ovals } {
    #item 387
    return [ list $vertex1 $vertex2 $head $ovals ]
}

proc make_field_key { class_id field_name } {
    #item 170
    set name [ string tolower $field_name ]
    #item 171
    return "${class_id},${name}"
}

proc make_foreign_check { field link action } {
    #item 2579
    set target [ get_target $link ]
    #item 2604
    return \
     [ list "action" "foreign_check" \
     "field" $field "class" $target \
     "action" $action ]
}

proc print_action { chunk indent } {
    #item 2187
    puts -nonewline $indent
    #item 2178
    set keys [ dict keys $chunk ]
    foreach key $keys {
        #item 2181
        set value [ dict get $chunk $key ]
        #item 2186
        print_prop $key $value
    }
    #item 2188
    puts ""
}

proc print_block { block indent } {
    foreach item $block {
        #item 2410
        print_item $item "    $indent"
    }
}

proc print_for { chunk indent } {
    #item 2444
    set condition [ dict get $chunk "foreach" ]
    set body [ dict get $chunk "do" ]
    #item 2445
    puts "${indent}foreach"
    #item 2447
    print_action $condition "    $indent"
    #item 2446
    puts "${indent}do"
    #item 2448
    print_item $body "    $indent"
}

proc print_if { chunk indent } {
    #item 2423
    set condition [ dict get $chunk "if" ]
    set body [ dict get $chunk "then" ]
    #item 2435
    puts "${indent}if"
    #item 2437
    print_action $condition "    $indent"
    #item 2436
    puts "${indent}then"
    #item 2438
    print_item $body "    $indent"
}

proc print_item { item indent } {
    #item 2162
    set first [ lindex $item 0 ]
    #item 21630001
    if {$first == ""} {
        
    } else {
        #item 21630002
        if {$first == "foreach"} {
            #item 2417
            print_for $item $indent
        } else {
            #item 21630003
            if {$first == "if"} {
                #item 2414
                print_if $item $indent
            } else {
                #item 21630004
                if {$first == "action"} {
                    #item 2171
                    print_action $item $indent
                } else {
                    
                }
            }
        }
    }
}

proc print_list { list output } {
    foreach item $list {
        #item 2035
        puts $output "    $item"
    }
}

proc print_proc { chunk } {
    #item 2148
    set body {}
    #item 2144
    set keys [ dict keys $chunk ]
    foreach key $keys {
        #item 2147
        set value [ dict get $chunk $key ]
        #item 2149
        if {$key == "body"} {
            #item 2152
            set body $value
        } else {
            #item 2153
            print_prop $key $value
        }
    }
    #item 2189
    puts ""
    #item 2411
    print_block $body ""
}

proc print_prop { key value } {
    #item 21150001
    if {$key == "class"} {
        #item 2122
        set name [ get_class_name $value ]
    } else {
        #item 21150002
        if {$key == "link"} {
            #item 2132
            set dst [ get_link_dst_table $value ]
            set src [ get_link_src_table $value ]
            set dname [ get_class_name $dst ]
            set sname [ get_class_name $src ]
            set type [ get_link_type $value ]
            set name "$type:$sname->$dname"
        } else {
            #item 21150003
            if {$key == "index"} {
                #item 2129
                set class [ get_index_class $value ]
                set fields [ get_index_fields $value ]
                set fields_str [ join $fields "-" ]
                set cname [ get_class_name $class ]
                set name "${cname}:$fields_str"
            } else {
                #item 21150004
                if {($key == "field") || ($key == "new")} {
                    #item 2134
                    set name [ get_field_name $value ]
                } else {
                    #item 21150006
                    if {(($key == "old") || ($key == "fields")) || ($key == "all")} {
                        #item 2135
                        set names [ map2 $value tab::get_field_name ]
                        set name [ join $names "-" ]
                    } else {
                        #item 2136
                        set name $value
                    }
                }
            }
        }
    }
    #item 2138
    puts -nonewline " $key=$name"
}

proc remove { collection element } {
    #item 2061
    set found [ lsearch $collection $element ]
    #item 2062
    if {$found == -1} {
        #item 2065
        return $collection
    } else {
        #item 2066
        return [ lreplace $collection $found $found ]
    }
}

proc report_error_class { name message } {
    #item 1898
    set vertexes [ vertex_type_keys ]
    
    set normal_1899 1
    foreach vertex $vertexes {
        #item 1901
        set text [ get_vertex_text $vertex ]
        set text2 [ get_vertex_text2 $vertex ]
        set type [ get_vertex_type $vertex ]
        #item 1902
        if {(($type == "action") && ($text == $name)) || (($type == "shelf") && ($text2 == "class $name"))} {
            #item 1911
            report_error_vertex $vertex $message
            set normal_1899 0
            break
        } else {
            
        }
    }
    if {$normal_1899 == 1} {
        #item 1908
        error "Error in class $name."
    }
}

proc report_error_edge { edge_id message } {
    #item 273
    set vertex1 [ get_edge_vertex1 $edge_id ]
    set diagram_id [ get_vertex_diagram_id $vertex1 ]
    set name [ get_diagram_name $diagram_id ]
    set item [ get_edge_items $edge_id ]
    #item 275
    gen::report_error $diagram_id $item $message
}

proc report_error_vertex { vertex_id message } {
    #item 281
    set diagram_id [ get_vertex_diagram_id $vertex_id ]
    set name [ get_diagram_name $diagram_id ]
    set item [ get_vertex_item_id $vertex_id ]
    #item 846
    gen::report_error $diagram_id $item $message
}

proc report_wrong_ovals { edge_id } {
    #item 1223
    set message "Unexpected number of link fields"
    #item 1311
    report_error_edge $edge_id $message
}

proc reset_db { } {
    #item 69
    art::create_table tab diagram {
    	name 
    	vertices
    }
    #item 98
    art::create_table tab vertex {
    	item_id 
    	diagram_id
    	type 
    	text
    	text2
    	left 
    	up 
    	right 
    	down
    }
    #item 99
    art::create_table tab edge {
    	vertex1 
    	vertex2 
    	head 
    	vertical 
    	items 
    	marked
    }
    #item 78
    art::create_table tab connection {
    	vertex1 
    	vertex2 
    	orientation
    	head
    	ovals
    	edge
    }
    #item 1318
    art::create_table tab index_info {
    	class_id
    	data
    	vertex
    }
    #item 1395
    art::create_table tab empty_link {
    	type
    	ownership
    	src
    	dst
    	edge
    }
    #item 79
    art::create_table tab class {
    	name
    	properties
    	fields
    	indexes
    	links
    	defined
    }
    #item 80
    art::create_table tab field {
    	class
    	name
    	properties
    }
    #item 96
    art::create_table tab index {
    	class
    	name
    	properties
    	fields
    }
    #item 97
    art::create_table tab link {
    	type
    	ownership
    	src_table
    	dst_table
    	src_field
    	dst_field
    }
    #item 1430
    art::create_table tab class2 {
    	simple
    	base
    	derived
    	has_ref_count
    	master_arrow
    }
    #item 1423
    art::create_table tab field2 {
    	type
    	link
    	incoming
    	outgoing
    	indexes
    }
    #item 100
    art::create_table tab field_by_name {
    	field
    }
    #item 122
    art::create_table tab class_by_name {
    	class
    }
}

proc select_fields { class field_selector } {
    #item 2072
    set result {}
    #item 2076
    set fields [ get_class_fields $class ]
    foreach field $fields {
        #item 2196
        set type [ get_field2_type $field ]
        set indexes [ get_field2_indexes $field ]
        #item 2077
        if {(($field_selector == "") || (!([ $field_selector $field ]))) && ($indexes == {})} {
            
        } else {
            #item 2080
            lappend result $field
        }
    }
    #item 2073
    return $result
}

proc select_hor_head { edge_id left right } {
    #item 424
    if {$left == ""} {
        #item 427
        return $right
    } else {
        #item 428
        if {$right == ""} {
            #item 431
            return $left
        } else {
            #item 601
            if {($left == "left paw") && ($right == "right paw")} {
                #item 604
                return "m2m"
            } else {
                #item 599
                puts "select_hor_head:"
                puts "left=$left"
                puts "righ=$right"
                #item 432
                report_error_edge $edge_id \
                	"Simple line expected"
            }
        }
    }
}

proc select_ver_head { edge_id left right } {
    #item 829
    if {$left == ""} {
        #item 832
        return $right
    } else {
        #item 833
        if {$right == ""} {
            #item 836
            return $left
        } else {
            #item 838
            puts "select_ver_head:"
            puts "left=$left"
            puts "righ=$right"
            #item 837
            report_error_edge $edge_id \
            	"Simple line expected"
        }
    }
}

proc split_lines { text } {
    #item 946
    set lines [ split $text "\n" ]
    #item 947
    set result {}
    foreach line $lines {
        #item 956
        set trimmed [ string trim $line ]
        #item 951
        if {($trimmed == "") || ([string match "#*" $trimmed])} {
            
        } else {
            #item 954
            lappend result $trimmed
        }
    }
    #item 948
    return $result
}

proc split_space { text } {
    #item 926
    set parts [ split $text " \t" ]
    #item 927
    set result {}
    foreach part $parts {
        #item 931
        if {$part == ""} {
            
        } else {
            #item 934
            lappend result $part
        }
    }
    #item 928
    return $result
}

}
