namespace eval hie_engine {

variable non_tokens     " \t\n!@#$%^&*\(\)+-=,<>/?:;\[\{\}\]\\|\"'."
variable non_tokens_tcl " \t\n!@#$%^&*\(\)+-=,<>/?:;\[\{\}\]\\|\"'"

variable diagrams {}
variable roots {}
variable leafs {}

array set callers {}
array set back {}
array set names {}


# Autogenerated with DRAKON Editor 1.27

proc add.call { caller called } {
    #item 118
    variable callers
    variable back
    #item 122
    set called_procs [ get.called $caller ]
    #item 123
    lappend called_procs $called
    #item 124
    set callers($caller) $called_procs
    #item 202
    set caller_procs [ get.back $called ]
    #item 203
    lappend caller_procs $caller
    #item 204
    set back($called) $caller_procs
}

proc build.called.list { } {
    #item 181
    set callers [ get.callers ]
    #item 182
    set called {}
    foreach caller $callers {
        #item 186
        set this_called [ get.called $caller ]
        #item 187
        set called [ concat $called $this_called ]
    }
    #item 183
    return [ lsort -unique -integer $called ]
}

proc build.graph { } {
    #item 47
    variable roots
    variable leafs
    variable callers
    variable names
    variable diagrams
    #item 48
    set roots {}
    set leafs {}
    set diagrams {}
    clear_array hie_engine::callers
    clear_array hie_engine::back
    clear_array hie_engine::names
    #item 49
    array set properties [ mwc::get_file_properties ]
    #item 50
    if {([info exists properties(language)]) && (!($properties(language) == "Tcl"))} {
        #item 56
        set is_tcl 0
    } else {
        #item 55
        set is_tcl 1
    }
    #item 64
    set db $mwc::db
    #item 72
    $db eval {
    	select diagram_id, name
    	from diagrams
    } {
    	if { [ mwc::is_drakon $diagram_id ] } {
    		lappend diagrams $diagram_id
    		set names($diagram_id) $name
    	}
    }
    foreach called $diagrams {
        #item 77
        set called_name $names($called)
        foreach caller $diagrams {
            #item 79
            set tokens \
            [get.tokens $db $caller $is_tcl]
            #item 80
            if {[contains $tokens $called_name]} {
                #item 83
                add.call $caller $called
            } else {
                
            }
        }
    }
    #item 176
    set caller_procs [ get.callers ]
    #item 188
    set called [ build.called.list ]
    #item 189
    set roots [ subtract $diagrams $called ]
    #item 190
    set leafs [ subtract $called $caller_procs ]
}

proc get.all { } {
    #item 160
    variable diagrams
    #item 161
    return $diagrams
}

proc get.back { called } {
    #item 196
    variable back
    #item 198
    if {[info exists back($called)]} {
        #item 197
        return $back($called)
    } else {
        #item 201
        return {}
    }
}

proc get.called { caller } {
    #item 143
    variable callers
    #item 145
    if {[info exists callers($caller)]} {
        #item 144
        return $callers($caller)
    } else {
        #item 148
        return {}
    }
}

proc get.callers { } {
    #item 208
    variable callers
    #item 209
    return [ array names callers ]
}

proc get.leafs { } {
    #item 167
    variable leafs
    #item 166
    return $leafs
}

proc get.name { diagram_id } {
    #item 154
    variable names
    #item 155
    return $names($diagram_id)
}

proc get.roots { } {
    #item 172
    variable roots
    #item 171
    return $roots
}

proc get.tokens { db diagram_id is_tcl } {
    #item 109
    set tokens {}
    #item 110
    $db eval {
    	select text
    	from items
    	where diagram_id = :diagram_id
    	and type not in ('commentin', 'commentout', 'beginend')
    } {
    	set item_tokens [ lex $text $is_tcl ]
    	set tokens [ concat $tokens $item_tokens ]
    }
    #item 111
    return [ lsort -unique $tokens ]
}

proc lex { text is_tcl } {
    #item 94
    variable non_tokens_tcl
    variable non_tokens
    #item 89
    if {$is_tcl} {
        #item 93
        set split_chars $non_tokens_tcl
    } else {
        #item 92
        set split_chars $non_tokens
    }
    #item 95
    set parts [ split $text $split_chars ]
    #item 96
    set output {}
    foreach part $parts {
        #item 98
        if {$part == ""} {
            
        } else {
            #item 103
            lappend output $part
        }
    }
    #item 97
    return $output
}

}
