/* Autogenerated with DRAKON Editor 1.23 */
#include "peerarrow.h"

#include <memory.h>
#include <stdio.h>






struct peerarrow {
    tobject base;
    array_table employee;
    hashtable* employee_by_name_birthday;
    array_table department;
    hashtable* department_by_title;
    int error_code;
};
static type_info_t peerarrow_t = {
	OBJECT_SIGNATURE,
	"peerarrow",
	(destructor_fun)peerarrow_destroy
};
struct employee {
    row_base _row;
    string8* name;
    int birthday;
    department* department;
};
struct department {
    row_base _row;
    int _ref_count;
    string8* title;
};


static int
delete_generic(peerarrow* db,
    obj_list* deletion_list);


static int
ensure_can_delete(peerarrow* db,
    void* record,
    obj_list* deletion_list);


static void
do_delete(peerarrow* db,
    void* record,
    obj_list* deletion_list,
    int unlink);


static int
record_destructor(void* record,
    void* dbv);


static int
employee_pre_delete(peerarrow* db,
    employee* record,
    obj_list* deletion_list,
    int master);


static int
employee_ensure_can_delete(peerarrow* db,
    employee* record,
    obj_list* deletion_list);


static void
employee_do_delete(peerarrow* db,
    employee* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
employee_by_name_birthday_hash(const void* vobj);


static int
employee_by_name_birthday_eq(const void* lobj,
    const void* robj);


static int
department_pre_delete(peerarrow* db,
    department* record,
    obj_list* deletion_list,
    int master);


static int
department_ensure_can_delete(peerarrow* db,
    department* record,
    obj_list* deletion_list);


static void
department_do_delete(peerarrow* db,
    department* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
department_by_title_hash(const void* vobj);


static int
department_by_title_eq(const void* lobj,
    const void* robj);


peerarrow* /* own */
peerarrow_create(void) {
    peerarrow* me = allocate_memory(sizeof(peerarrow));
    me->base.type = &peerarrow_t;
    array_table_init(&me->employee, "employee");
    me->employee.do_delete = (dd_fun)employee_do_delete;
    me->employee.ensure_can_delete = (ensure_cd_fun)employee_ensure_can_delete;
    me->employee_by_name_birthday = hashtable_create(0, employee_by_name_birthday_hash, employee_by_name_birthday_eq);
    array_table_init(&me->department, "department");
    me->department.do_delete = (dd_fun)department_do_delete;
    me->department.ensure_can_delete = (ensure_cd_fun)department_ensure_can_delete;
    me->department_by_title = hashtable_create(0, department_by_title_hash, department_by_title_eq);
    return me;
}


void
peerarrow_destroy(peerarrow* me /* own. null */) {
    if (!me) return;
    ENSURE(me->base.type == &peerarrow_t)
    hashtable_destroy(me->employee_by_name_birthday);
    peerarrow_foreach_employee(
        me,
        (employee_fun)record_destructor,
        me);
    array_table_cleanup(&me->employee);
    hashtable_destroy(me->department_by_title);
    peerarrow_foreach_department(
        me,
        (department_fun)record_destructor,
        me);
    array_table_cleanup(&me->department);
    free_memory(me, sizeof(peerarrow));
}


int
peerarrow_error(const peerarrow* db) {
    return db->error_code;
}


int
employee_id(const employee* me) {
    return me->_row.id;
}


employee* /* null */
peerarrow_get_employee(peerarrow* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->employee.next) return 0;
    return db->employee.items[rec_id];
}


const string8* /* null */
employee_cget_name(const employee* me) {
    return me->name;
}


department* /* null */
employee_department(employee* me) {
    return me->department;
}


int
peerarrow_set_employee_name(peerarrow* db,
    employee* _record_,
    string8* new_value /* own. null */) {
    employee* found;
    employee _key_;
    ENSURE(_record_ == peerarrow_get_employee(db, _record_->_row.id))
    if (_record_->name == new_value) {
        return 1;
    }
    _key_.name = new_value;
    _key_.birthday = _record_->birthday;
    found = hashtable_get(db->employee_by_name_birthday, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    hashtable_remove(db->employee_by_name_birthday, _record_);
    if (_record_->name) {
        string8_destroy(_record_->name);
    }
    _record_->name = new_value;
    hashtable_put(db->employee_by_name_birthday, _record_);
    return 1;
}


int
peerarrow_set_employee_department(peerarrow* db,
    employee* _record_,
    department* new_value /* null */) {
    ENSURE(_record_ == peerarrow_get_employee(db, _record_->_row.id))
    if (_record_->department == new_value) {
        return 1;
    }
    if (new_value) {
        ENSURE(new_value == peerarrow_get_department(db, new_value->_row.id))
    }
    if (_record_->department != 0 ) {
        _record_->department->_ref_count--;
    }
    _record_->department = new_value;
    if (_record_->department != 0 ) {
        _record_->department->_ref_count++;
    }
    return 1;
}


employee* /* null */
peerarrow_insert_employee(peerarrow* db,
    string8* name /* own. null */,
    int birthday) {
    employee* _record_;
    int rec_id;
    employee _key_;
    employee* found;
    _record_ = 0;
    _key_.name = name;
    _key_.birthday = birthday;
    found = hashtable_get(db->employee_by_name_birthday, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    _record_ = allocate_memory(sizeof(employee));
    rec_id = array_table_insert(&db->employee, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->employee;
    _record_->name = name;
    _record_->birthday = birthday;
    hashtable_put(db->employee_by_name_birthday, _record_);
    return _record_;
}


int
peerarrow_delete_employee(peerarrow* db,
    employee* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == peerarrow_get_employee(db, record->_row.id))
    if (employee_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
peerarrow_employee_count(const peerarrow* db) {
    return db->employee.count;
}


int
peerarrow_foreach_employee(peerarrow* db,
    employee_fun visitor,
    void* user_data /* null */) {
    int i, n;
    employee* current;
    n = db->employee.next;
    for (i = 0; i < n; i++) {
        current = db->employee.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


employee* /* null */
peerarrow_employee_by_name_birthday(peerarrow* db,
    const string8* name /* null */,
    int birthday) {
    employee _key_;
    _key_.name = (string8*)name;
    _key_.birthday = birthday;
    return hashtable_get(db->employee_by_name_birthday, &_key_);
}


int
department_id(const department* me) {
    return me->_row.id;
}


department* /* null */
peerarrow_get_department(peerarrow* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->department.next) return 0;
    return db->department.items[rec_id];
}


const string8* /* null */
department_cget_title(const department* me) {
    return me->title;
}


department* /* null */
peerarrow_insert_department(peerarrow* db,
    string8* title /* own. null */) {
    department* _record_;
    int rec_id;
    department _key_;
    department* found;
    _record_ = 0;
    _key_.title = title;
    found = hashtable_get(db->department_by_title, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    _record_ = allocate_memory(sizeof(department));
    rec_id = array_table_insert(&db->department, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->department;
    _record_->title = title;
    hashtable_put(db->department_by_title, _record_);
    _record_->_ref_count = 0;
    return _record_;
}


int
peerarrow_delete_department(peerarrow* db,
    department* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == peerarrow_get_department(db, record->_row.id))
    if (department_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
peerarrow_department_count(const peerarrow* db) {
    return db->department.count;
}


int
peerarrow_foreach_department(peerarrow* db,
    department_fun visitor,
    void* user_data /* null */) {
    int i, n;
    department* current;
    n = db->department.next;
    for (i = 0; i < n; i++) {
        current = db->department.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


department* /* null */
peerarrow_department_by_title(peerarrow* db,
    const string8* title /* null */) {
    department _key_;
    _key_.title = (string8*)title;
    return hashtable_get(db->department_by_title, &_key_);
}


static int
delete_generic(peerarrow* db,
    obj_list* deletion_list) {
    void* record;
    int i, n;
    n = obj_list_length(deletion_list);
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        if (!ensure_can_delete(db, record, deletion_list)) {
            return 0;
        }
    }
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        do_delete(db, record, deletion_list, 1);
    }
    return 1;
}


static int
ensure_can_delete(peerarrow* db,
    void* record,
    obj_list* deletion_list) {
    row_base* row = record;
    return row->table->ensure_can_delete(
        db,
        record,
        deletion_list);
}


static void
do_delete(peerarrow* db,
    void* record,
    obj_list* deletion_list,
    int unlink) {
    row_base* row = record;
    row->table->do_delete(
        db,
        record,
        deletion_list,
        unlink);
}


static int
record_destructor(void* record,
    void* dbv) {
    peerarrow* db = dbv;
    do_delete(
        db,
        record,
        0,
        0);
    return 0;
}


static int
employee_pre_delete(peerarrow* db,
    employee* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    return 1;
}


static int
employee_ensure_can_delete(peerarrow* db,
    employee* record,
    obj_list* deletion_list) {
    return 1;
}


static void
employee_do_delete(peerarrow* db,
    employee* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        if (record->department != 0 ) {
            if ( !obj_list_contains(deletion_list, record->department)) {
                record->department->_ref_count--;
            }
        }
        hashtable_remove(db->employee_by_name_birthday, record);
        array_table_delete(&db->employee, record->_row.id);
    }
    string8_destroy(record->name);
    free_memory(record, sizeof(employee));
}


static unsigned int
employee_by_name_birthday_hash(const void* vobj) {
    const employee* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = string8_hash(obj->name);
    code = (code * 397) ^ ((unsigned int)obj->birthday);
    return code;
}


static int
employee_by_name_birthday_eq(const void* lobj,
    const void* robj) {
    const employee* left;
    const employee* right;
    left = lobj;
    right = robj;
    if (!string8_equal(left->name, right->name)) return 0;
    if (left->birthday != right->birthday) return 0;
    return 1;
}


static int
department_pre_delete(peerarrow* db,
    department* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    if ( record->_ref_count > 0 ) {
        db->error_code = 2;
        return 0;
    }
    return 1;
}


static int
department_ensure_can_delete(peerarrow* db,
    department* record,
    obj_list* deletion_list) {
    return 1;
}


static void
department_do_delete(peerarrow* db,
    department* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        hashtable_remove(db->department_by_title, record);
        array_table_delete(&db->department, record->_row.id);
    }
    string8_destroy(record->title);
    free_memory(record, sizeof(department));
}


static unsigned int
department_by_title_hash(const void* vobj) {
    const department* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = string8_hash(obj->title);
    return code;
}


static int
department_by_title_eq(const void* lobj,
    const void* robj) {
    const department* left;
    const department* right;
    left = lobj;
    right = robj;
    if (!string8_equal(left->title, right->title)) return 0;
    return 1;
}
int main(
    int argc,
    char** argv
) {
    // item 218
    employee* john;
    employee* john2;
    employee* mark;
    department* marketing;
    department* sales;
    department* logistics;
    /* item 159 */
    peerarrow* db = peerarrow_create();
    string8* m_str = string8_from_cstr("Marketing", 10);
    string8* s_str = string8_from_cstr("Sales", 10);
    string8* l_str = string8_from_cstr("Logistics", 10);
    /* item 76 */
    john = peerarrow_insert_employee(db, 
     string8_from_cstr("John", 10), 1978);
    mark = peerarrow_insert_employee(db,
     string8_from_cstr("Mark", 10), 1978);
    john2 = peerarrow_insert_employee(db,
     string8_from_cstr("John", 10), 1985);
    /* item 75 */
    ENSURE(peerarrow_insert_department(db,
     string8_from_cstr("Marketing", 10)))
    ENSURE(peerarrow_insert_department(db, 
     string8_from_cstr("Sales", 10)))
    ENSURE(peerarrow_insert_department(db,
     string8_from_cstr("Logistics", 10)))
    
    marketing = peerarrow_department_by_title(db, m_str);
    sales     = peerarrow_department_by_title(db, s_str);
    logistics = peerarrow_department_by_title(db, l_str);
    /* item 205 */
    ENSURE(0 == employee_department(john))
    ENSURE(0 == employee_department(john2))
    ENSURE(0 == employee_department(mark))
    /* item 137 */
    ENSURE(peerarrow_set_employee_department(db, john, 0))
    ENSURE(peerarrow_set_employee_department(db, john2, 0))
    ENSURE(peerarrow_set_employee_department(db, mark, 0))
    /* item 219 */
    ENSURE(0 == employee_department(john))
    ENSURE(0 == employee_department(john2))
    ENSURE(0 == employee_department(mark))
    /* item 138 */
    ENSURE(peerarrow_set_employee_department(db, john, marketing))
    ENSURE(peerarrow_set_employee_department(db, john2, sales))
    ENSURE(peerarrow_set_employee_department(db, mark, marketing))
    /* item 220 */
    ENSURE(marketing == employee_department(john))
    ENSURE(sales == employee_department(john2))
    ENSURE(marketing == employee_department(mark))
    /* item 141 */
    ENSURE(peerarrow_set_employee_department(db, john, marketing))
    ENSURE(peerarrow_set_employee_department(db, john2, logistics))
    ENSURE(peerarrow_set_employee_department(db, mark, 0))
    /* item 221 */
    ENSURE(marketing == employee_department(john))
    ENSURE(logistics == employee_department(john2))
    ENSURE(0 == employee_department(mark))
    /* item 143 */
    ENSURE(peerarrow_delete_department(db, sales))
    ENSURE(0 == peerarrow_department_by_title(db, s_str))
    /* item 144 */
    ENSURE(0 == peerarrow_delete_department(db, marketing))
    ENSURE(0 == peerarrow_delete_department(db, logistics))
    /* item 100 */
    ENSURE(peerarrow_delete_employee(db, john))
    ENSURE(peerarrow_delete_department(db, marketing))
    /* item 101 */
    ENSURE(peerarrow_set_employee_department(db, john2, 0))
    ENSURE(peerarrow_delete_department(db, logistics))
    /* item 145 */
    ENSURE(2 == peerarrow_employee_count(db))
    ENSURE(0 == peerarrow_department_count(db))
    /* item 222 */
    object_destroy(db);
    object_destroy(m_str);
    object_destroy(s_str);
    object_destroy(l_str);
    /* item 217 */
    return 0;
    
}



