/* Autogenerated with DRAKON Editor 1.23 */
#include "peerpaw.h"

#include <memory.h>
#include <stdio.h>






struct peerpaw {
    tobject base;
    array_table employee;
    hashtable* employee_by_department_name;
    array_table department;
    hashtable* department_by_title;
    int error_code;
};
static type_info_t peerpaw_t = {
	OBJECT_SIGNATURE,
	"peerpaw",
	(destructor_fun)peerpaw_destroy
};
struct employee {
    row_base _row;
    string8* name;
    department* department;
};
struct department {
    row_base _row;
    string8* title;
    obj_list* employees;
};


static int
delete_generic(peerpaw* db,
    obj_list* deletion_list);


static int
ensure_can_delete(peerpaw* db,
    void* record,
    obj_list* deletion_list);


static void
do_delete(peerpaw* db,
    void* record,
    obj_list* deletion_list,
    int unlink);


static int
record_destructor(void* record,
    void* dbv);


static int
employee_pre_delete(peerpaw* db,
    employee* record,
    obj_list* deletion_list,
    int master);


static int
employee_ensure_can_delete(peerpaw* db,
    employee* record,
    obj_list* deletion_list);


static void
employee_do_delete(peerpaw* db,
    employee* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
employee_by_department_name_hash(const void* vobj);


static int
employee_by_department_name_eq(const void* lobj,
    const void* robj);


static int
department_pre_delete(peerpaw* db,
    department* record,
    obj_list* deletion_list,
    int master);


static int
department_ensure_can_delete(peerpaw* db,
    department* record,
    obj_list* deletion_list);


static void
department_do_delete(peerpaw* db,
    department* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
department_by_title_hash(const void* vobj);


static int
department_by_title_eq(const void* lobj,
    const void* robj);


peerpaw* /* own */
peerpaw_create(void) {
    peerpaw* me = allocate_memory(sizeof(peerpaw));
    me->base.type = &peerpaw_t;
    array_table_init(&me->employee, "employee");
    me->employee.do_delete = (dd_fun)employee_do_delete;
    me->employee.ensure_can_delete = (ensure_cd_fun)employee_ensure_can_delete;
    me->employee_by_department_name = hashtable_create(0, employee_by_department_name_hash, employee_by_department_name_eq);
    array_table_init(&me->department, "department");
    me->department.do_delete = (dd_fun)department_do_delete;
    me->department.ensure_can_delete = (ensure_cd_fun)department_ensure_can_delete;
    me->department_by_title = hashtable_create(0, department_by_title_hash, department_by_title_eq);
    return me;
}


void
peerpaw_destroy(peerpaw* me /* own. null */) {
    if (!me) return;
    ENSURE(me->base.type == &peerpaw_t)
    hashtable_destroy(me->employee_by_department_name);
    peerpaw_foreach_employee(
        me,
        (employee_fun)record_destructor,
        me);
    array_table_cleanup(&me->employee);
    hashtable_destroy(me->department_by_title);
    peerpaw_foreach_department(
        me,
        (department_fun)record_destructor,
        me);
    array_table_cleanup(&me->department);
    free_memory(me, sizeof(peerpaw));
}


int
peerpaw_error(const peerpaw* db) {
    return db->error_code;
}


int
employee_id(const employee* me) {
    return me->_row.id;
}


employee* /* null */
peerpaw_get_employee(peerpaw* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->employee.next) return 0;
    return db->employee.items[rec_id];
}


const string8* /* null */
employee_cget_name(const employee* me) {
    return me->name;
}


int
peerpaw_set_employee_department(peerpaw* db,
    employee* _record_,
    department* new_value /* null */) {
    employee* found;
    employee _key_;
    ENSURE(_record_ == peerpaw_get_employee(db, _record_->_row.id))
    if (_record_->department == new_value) {
        return 1;
    }
    _key_.department = new_value;
    _key_.name = _record_->name;
    found = hashtable_get(db->employee_by_department_name, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    if (new_value) {
        ENSURE(new_value == peerpaw_get_department(db, new_value->_row.id))
    }
    if (_record_->department != 0 ) {
        obj_list_remove(_record_->department->employees, _record_);
    }
    hashtable_remove(db->employee_by_department_name, _record_);
    _record_->department = new_value;
    hashtable_put(db->employee_by_department_name, _record_);
    if (_record_->department != 0 ) {
        obj_list_add(_record_->department->employees, _record_);
    }
    return 1;
}


employee* /* null */
peerpaw_insert_employee(peerpaw* db,
    string8* name /* own. null */,
    department* department /* null */) {
    employee* _record_;
    int rec_id;
    employee _key_;
    employee* found;
    _record_ = 0;
    _key_.department = department;
    _key_.name = name;
    found = hashtable_get(db->employee_by_department_name, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    if (department) {
        ENSURE(department == peerpaw_get_department(db, department->_row.id))
    }
    _record_ = allocate_memory(sizeof(employee));
    rec_id = array_table_insert(&db->employee, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->employee;
    _record_->name = name;
    _record_->department = department;
    hashtable_put(db->employee_by_department_name, _record_);
    if (_record_->department != 0 ) {
        obj_list_add(_record_->department->employees, _record_);
    }
    return _record_;
}


int
peerpaw_delete_employee(peerpaw* db,
    employee* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == peerpaw_get_employee(db, record->_row.id))
    if (employee_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
peerpaw_employee_count(const peerpaw* db) {
    return db->employee.count;
}


int
peerpaw_foreach_employee(peerpaw* db,
    employee_fun visitor,
    void* user_data /* null */) {
    int i, n;
    employee* current;
    n = db->employee.next;
    for (i = 0; i < n; i++) {
        current = db->employee.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


employee* /* null */
peerpaw_employee_by_department_name(peerpaw* db,
    const department* department /* null */,
    const string8* name /* null */) {
    employee _key_;
    _key_.department = (struct department*)department;
    _key_.name = (string8*)name;
    return hashtable_get(db->employee_by_department_name, &_key_);
}


int
department_id(const department* me) {
    return me->_row.id;
}


department* /* null */
peerpaw_get_department(peerpaw* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->department.next) return 0;
    return db->department.items[rec_id];
}


int
department_employees_count(const department* record) {
    return obj_list_length(record->employees);
}


employee*
department_employees(department* record,
    int index) {
    return obj_list_get(record->employees, index);
}


department* /* null */
peerpaw_insert_department(peerpaw* db,
    string8* title /* own. null */) {
    department* _record_;
    int rec_id;
    department _key_;
    department* found;
    _record_ = 0;
    _key_.title = title;
    found = hashtable_get(db->department_by_title, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    _record_ = allocate_memory(sizeof(department));
    rec_id = array_table_insert(&db->department, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->department;
    _record_->title = title;
    hashtable_put(db->department_by_title, _record_);
    _record_->employees = obj_list_create(0);
    return _record_;
}


int
peerpaw_delete_department(peerpaw* db,
    department* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == peerpaw_get_department(db, record->_row.id))
    if (department_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
peerpaw_department_count(const peerpaw* db) {
    return db->department.count;
}


int
peerpaw_foreach_department(peerpaw* db,
    department_fun visitor,
    void* user_data /* null */) {
    int i, n;
    department* current;
    n = db->department.next;
    for (i = 0; i < n; i++) {
        current = db->department.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


department* /* null */
peerpaw_department_by_title(peerpaw* db,
    const string8* title /* null */) {
    department _key_;
    _key_.title = (string8*)title;
    return hashtable_get(db->department_by_title, &_key_);
}


static int
delete_generic(peerpaw* db,
    obj_list* deletion_list) {
    void* record;
    int i, n;
    n = obj_list_length(deletion_list);
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        if (!ensure_can_delete(db, record, deletion_list)) {
            return 0;
        }
    }
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        do_delete(db, record, deletion_list, 1);
    }
    return 1;
}


static int
ensure_can_delete(peerpaw* db,
    void* record,
    obj_list* deletion_list) {
    row_base* row = record;
    return row->table->ensure_can_delete(
        db,
        record,
        deletion_list);
}


static void
do_delete(peerpaw* db,
    void* record,
    obj_list* deletion_list,
    int unlink) {
    row_base* row = record;
    row->table->do_delete(
        db,
        record,
        deletion_list,
        unlink);
}


static int
record_destructor(void* record,
    void* dbv) {
    peerpaw* db = dbv;
    do_delete(
        db,
        record,
        0,
        0);
    return 0;
}


static int
employee_pre_delete(peerpaw* db,
    employee* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    return 1;
}


static int
employee_ensure_can_delete(peerpaw* db,
    employee* record,
    obj_list* deletion_list) {
    return 1;
}


static void
employee_do_delete(peerpaw* db,
    employee* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        if (record->department != 0 ) {
            if ( !obj_list_contains(deletion_list, record->department)) {
                obj_list_remove(record->department->employees, record);
            }
        }
        hashtable_remove(db->employee_by_department_name, record);
        array_table_delete(&db->employee, record->_row.id);
    }
    string8_destroy(record->name);
    free_memory(record, sizeof(employee));
}


static unsigned int
employee_by_department_name_hash(const void* vobj) {
    const employee* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = (obj->department) ? (unsigned int)obj->department->_row.id : 0;
    code = (code * 397) ^ (string8_hash(obj->name));
    return code;
}


static int
employee_by_department_name_eq(const void* lobj,
    const void* robj) {
    const employee* left;
    const employee* right;
    left = lobj;
    right = robj;
    if (left->department != right->department) return 0;
    if (!string8_equal(left->name, right->name)) return 0;
    return 1;
}


static int
department_pre_delete(peerpaw* db,
    department* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    return 1;
}


static int
department_ensure_can_delete(peerpaw* db,
    department* record,
    obj_list* deletion_list) {
    int length, i;
    void* _that_;
    length = obj_list_length(record->employees);
    for (i = 0; i < length; i++) {
        _that_ = obj_list_get(record->employees, i);
        if (!obj_list_contains(deletion_list, _that_)) {
            db->error_code = 2;
            return 0;
        }
    }
    return 1;
}


static void
department_do_delete(peerpaw* db,
    department* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        hashtable_remove(db->department_by_title, record);
        array_table_delete(&db->department, record->_row.id);
    }
    string8_destroy(record->title);
    obj_list_destroy(record->employees);
    free_memory(record, sizeof(department));
}


static unsigned int
department_by_title_hash(const void* vobj) {
    const department* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = string8_hash(obj->title);
    return code;
}


static int
department_by_title_eq(const void* lobj,
    const void* robj) {
    const department* left;
    const department* right;
    left = lobj;
    right = robj;
    if (!string8_equal(left->title, right->title)) return 0;
    return 1;
}
int main(
    int argc,
    char** argv
) {
    // item 262
    department* yellow_m;
    department* grey_m;
    employee* mark;
    employee* john;
    /* item 255 */
    peerpaw* db = peerpaw_create();
    /* item 161 */
    yellow_m = peerpaw_insert_department(db,
     string8_from_cstr("Yellow marketing", 10));
    grey_m = peerpaw_insert_department(db, 
     string8_from_cstr("Grey marketing", 10));
    /* item 162 */
    mark = peerpaw_insert_employee(db,
     string8_from_cstr("Mark", 10), grey_m);
    john = peerpaw_insert_employee(db,
     string8_from_cstr("John", 10), 0);
    /* item 188 */
    ENSURE(peerpaw_set_employee_department(db, john, grey_m))
    /* item 189 */
    ENSURE(2 == department_employees_count(grey_m))
    ENSURE(0 == department_employees_count(yellow_m))
    
    ENSURE(mark = department_employees(grey_m, 0))
    ENSURE(john = department_employees(grey_m, 1))
    /* item 191 */
    ENSURE(peerpaw_set_employee_department(db, mark, yellow_m))
    /* item 261 */
    ENSURE(1 == department_employees_count(grey_m))
    ENSURE(1 == department_employees_count(yellow_m))
    
    ENSURE(john == department_employees(grey_m, 0))
    ENSURE(mark == department_employees(yellow_m, 0))
    /* item 194 */
    ENSURE(0 ==  peerpaw_delete_department(db, grey_m))
    ENSURE(0 ==  peerpaw_delete_department(db, yellow_m))
    /* item 195 */
    ENSURE(peerpaw_set_employee_department(db, mark, 0))
    /* item 196 */
    ENSURE(peerpaw_delete_department(db, yellow_m))
    /* item 197 */
    ENSURE(peerpaw_delete_employee(db, john))
    /* item 198 */
    ENSURE(peerpaw_delete_department(db, grey_m))
    /* item 260 */
    object_destroy(db);
    /* item 259 */
    return 0;
    
}



