/* Autogenerated with DRAKON Editor 1.23 */
#include "indexed2.h"

#include <memory.h>
#include <stdio.h>
static int str_eq(
    const char* expected,
    const string8* actual
);







struct indexed2 {
    tobject base;
    array_table employee;
    hashtable* employee_by_name_birthday;
    int error_code;
};
static type_info_t indexed2_t = {
	OBJECT_SIGNATURE,
	"indexed2",
	(destructor_fun)indexed2_destroy
};
struct employee {
    row_base _row;
    string8* name;
    int birthday;
};


static int
delete_generic(indexed2* db,
    obj_list* deletion_list);


static int
ensure_can_delete(indexed2* db,
    void* record,
    obj_list* deletion_list);


static void
do_delete(indexed2* db,
    void* record,
    obj_list* deletion_list,
    int unlink);


static int
record_destructor(void* record,
    void* dbv);


static int
employee_pre_delete(indexed2* db,
    employee* record,
    obj_list* deletion_list,
    int master);


static int
employee_ensure_can_delete(indexed2* db,
    employee* record,
    obj_list* deletion_list);


static void
employee_do_delete(indexed2* db,
    employee* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
employee_by_name_birthday_hash(const void* vobj);


static int
employee_by_name_birthday_eq(const void* lobj,
    const void* robj);


indexed2* /* own */
indexed2_create(void) {
    indexed2* me = allocate_memory(sizeof(indexed2));
    me->base.type = &indexed2_t;
    array_table_init(&me->employee, "employee");
    me->employee.do_delete = (dd_fun)employee_do_delete;
    me->employee.ensure_can_delete = (ensure_cd_fun)employee_ensure_can_delete;
    me->employee_by_name_birthday = hashtable_create(0, employee_by_name_birthday_hash, employee_by_name_birthday_eq);
    return me;
}


void
indexed2_destroy(indexed2* me /* own. null */) {
    if (!me) return;
    ENSURE(me->base.type == &indexed2_t)
    hashtable_destroy(me->employee_by_name_birthday);
    indexed2_foreach_employee(
        me,
        (employee_fun)record_destructor,
        me);
    array_table_cleanup(&me->employee);
    free_memory(me, sizeof(indexed2));
}


int
indexed2_error(const indexed2* db) {
    return db->error_code;
}


int
employee_id(const employee* me) {
    return me->_row.id;
}


employee* /* null */
indexed2_get_employee(indexed2* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->employee.next) return 0;
    return db->employee.items[rec_id];
}


const string8* /* null */
employee_cget_name(const employee* me) {
    return me->name;
}


int
employee_birthday(const employee* me) {
    return me->birthday;
}


int
indexed2_set_employee_name(indexed2* db,
    employee* _record_,
    string8* new_value /* own. null */) {
    employee* found;
    employee _key_;
    ENSURE(_record_ == indexed2_get_employee(db, _record_->_row.id))
    if (_record_->name == new_value) {
        return 1;
    }
    _key_.name = new_value;
    _key_.birthday = _record_->birthday;
    found = hashtable_get(db->employee_by_name_birthday, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    hashtable_remove(db->employee_by_name_birthday, _record_);
    if (_record_->name) {
        string8_destroy(_record_->name);
    }
    _record_->name = new_value;
    hashtable_put(db->employee_by_name_birthday, _record_);
    return 1;
}


int
indexed2_set_employee_birthday(indexed2* db,
    employee* _record_,
    int new_value) {
    employee* found;
    employee _key_;
    ENSURE(_record_ == indexed2_get_employee(db, _record_->_row.id))
    if (_record_->birthday == new_value) {
        return 1;
    }
    _key_.name = _record_->name;
    _key_.birthday = new_value;
    found = hashtable_get(db->employee_by_name_birthday, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    hashtable_remove(db->employee_by_name_birthday, _record_);
    _record_->birthday = new_value;
    hashtable_put(db->employee_by_name_birthday, _record_);
    return 1;
}


employee* /* null */
indexed2_insert_employee(indexed2* db,
    string8* name /* own. null */,
    int birthday) {
    employee* _record_;
    int rec_id;
    employee _key_;
    employee* found;
    _record_ = 0;
    _key_.name = name;
    _key_.birthday = birthday;
    found = hashtable_get(db->employee_by_name_birthday, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    _record_ = allocate_memory(sizeof(employee));
    rec_id = array_table_insert(&db->employee, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->employee;
    _record_->name = name;
    _record_->birthday = birthday;
    hashtable_put(db->employee_by_name_birthday, _record_);
    return _record_;
}


int
indexed2_delete_employee(indexed2* db,
    employee* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == indexed2_get_employee(db, record->_row.id))
    if (employee_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
indexed2_employee_count(const indexed2* db) {
    return db->employee.count;
}


int
indexed2_foreach_employee(indexed2* db,
    employee_fun visitor,
    void* user_data /* null */) {
    int i, n;
    employee* current;
    n = db->employee.next;
    for (i = 0; i < n; i++) {
        current = db->employee.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


employee* /* null */
indexed2_employee_by_name_birthday(indexed2* db,
    const string8* name /* null */,
    int birthday) {
    employee _key_;
    _key_.name = (string8*)name;
    _key_.birthday = birthday;
    return hashtable_get(db->employee_by_name_birthday, &_key_);
}


static int
delete_generic(indexed2* db,
    obj_list* deletion_list) {
    void* record;
    int i, n;
    n = obj_list_length(deletion_list);
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        if (!ensure_can_delete(db, record, deletion_list)) {
            return 0;
        }
    }
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        do_delete(db, record, deletion_list, 1);
    }
    return 1;
}


static int
ensure_can_delete(indexed2* db,
    void* record,
    obj_list* deletion_list) {
    row_base* row = record;
    return row->table->ensure_can_delete(
        db,
        record,
        deletion_list);
}


static void
do_delete(indexed2* db,
    void* record,
    obj_list* deletion_list,
    int unlink) {
    row_base* row = record;
    row->table->do_delete(
        db,
        record,
        deletion_list,
        unlink);
}


static int
record_destructor(void* record,
    void* dbv) {
    indexed2* db = dbv;
    do_delete(
        db,
        record,
        0,
        0);
    return 0;
}


static int
employee_pre_delete(indexed2* db,
    employee* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    return 1;
}


static int
employee_ensure_can_delete(indexed2* db,
    employee* record,
    obj_list* deletion_list) {
    return 1;
}


static void
employee_do_delete(indexed2* db,
    employee* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        hashtable_remove(db->employee_by_name_birthday, record);
        array_table_delete(&db->employee, record->_row.id);
    }
    string8_destroy(record->name);
    free_memory(record, sizeof(employee));
}


static unsigned int
employee_by_name_birthday_hash(const void* vobj) {
    const employee* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = string8_hash(obj->name);
    code = (code * 397) ^ ((unsigned int)obj->birthday);
    return code;
}


static int
employee_by_name_birthday_eq(const void* lobj,
    const void* robj) {
    const employee* left;
    const employee* right;
    left = lobj;
    right = robj;
    if (!string8_equal(left->name, right->name)) return 0;
    if (left->birthday != right->birthday) return 0;
    return 1;
}
static int str_eq(
    const char* expected,
    const string8* actual
) {
    // item 200
    int result;
    /* item 197 */
    string8* exp = string8_from_cstr(expected, 50); // own
    /* item 201 */
    result = string8_equal(actual, exp);
    /* item 198 */
    string8_destroy(exp);
    /* item 199 */
    return result;
    
}

int main(
    int argc,
    char** argv
) {
    // item 187
    int john_id, mark_id, john2_id;
    /* item 188 */
    employee* john;
    employee* john2;
    employee* mark;
    /* item 180 */
    indexed2* db = indexed2_create();
    string8* john_str = string8_from_cstr("John", 10);
    string8* mark_str = string8_from_cstr("Mark", 10);
    /* item 35 */
    ENSURE(0 == indexed2_employee_by_name_birthday(db, john_str, 1978))
    ENSURE(0 == indexed2_employee_by_name_birthday(db, john_str, 1980))
    ENSURE(0 == indexed2_employee_by_name_birthday(db, mark_str, 1965))
    /* item 76 */
    john = indexed2_insert_employee(
    	db,
    	string8_from_cstr("John", 10),
    	1978);
    /* item 77 */
    ENSURE(john)
    /* item 189 */
    john2 = indexed2_insert_employee(
    	db,
    	string8_from_cstr("John", 10),
    	1980);
    mark = indexed2_insert_employee(
    	db,
    	string8_from_cstr("Mark", 10),
    	1965);
    /* item 181 */
    ENSURE(john ==
     indexed2_employee_by_name_birthday(db, john_str, 1978))
    ENSURE(john2 ==
     indexed2_employee_by_name_birthday(db, john_str, 1980))
    ENSURE(mark ==
     indexed2_employee_by_name_birthday(db, mark_str, 1965))
    /* item 114 */
    ENSURE(!indexed2_insert_employee(db, mark_str, 1965))
    /* item 190 */
    john_id = employee_id(john);
    john2_id = employee_id(john2);
    mark_id = employee_id(mark);
    /* item 69 */
    ENSURE(str_eq("John", employee_cget_name(john)))
    ENSURE(str_eq("John", employee_cget_name(john2)))
    ENSURE(str_eq("Mark", employee_cget_name(mark)))
    ENSURE(1978 == employee_birthday(john))
    /* item 122 */
    ENSURE(!indexed2_set_employee_birthday(db, john, 1980))
    /* item 124 */
    ENSURE(indexed2_set_employee_name(db, mark,
    	string8_from_cstr("John", 100)))
    /* item 191 */
    ENSURE(john ==
     indexed2_employee_by_name_birthday(db, john_str, 1978))
    ENSURE(john2 ==
     indexed2_employee_by_name_birthday(db, john_str, 1980))
    ENSURE(mark ==
     indexed2_employee_by_name_birthday(db, john_str, 1965))
    /* item 125 */
    ENSURE(0 == indexed2_employee_by_name_birthday(db, mark_str, 1965))
    /* item 127 */
    ENSURE(str_eq("John", employee_cget_name(john)))
    ENSURE(str_eq("John", employee_cget_name(john2)))
    ENSURE(str_eq("John", employee_cget_name(mark)))
    /* item 99 */
    indexed2_delete_employee(db, john);
    indexed2_delete_employee(db, john2);
    /* item 100 */
    indexed2_delete_employee(db, mark);
    /* item 101 */
    ENSURE(0 == indexed2_get_employee(db, john_id))
    ENSURE(0 == indexed2_get_employee(db, john2_id))
    ENSURE(0 == indexed2_get_employee(db, mark_id))
    /* item 186 */
    ENSURE(0 == indexed2_employee_by_name_birthday(db, john_str, 1978))
    ENSURE(0 == indexed2_employee_by_name_birthday(db, john_str, 1980))
    ENSURE(0 == indexed2_employee_by_name_birthday(db, mark_str, 1965))
    /* item 185 */
    object_destroy(db);
    object_destroy(john_str);
    object_destroy(mark_str);
    /* item 184 */
    return 0;
    
}



